package org.seasar.nazuna;

import java.util.ArrayList;
import java.util.List;

import org.seasar.util.SeasarException;

public class RuleStatementContainerImpl extends AbstractRuleStatement
		implements RuleStatementContainer {

	private List _tempRuleStatementList = new ArrayList();
	protected RuleStatement[] _ruleStatements = RuleStatement.EMPTY_ARRAY;

	public RuleStatementContainerImpl(Object parent, String location) {
		super(parent, location);
	}
		
	public final void addRuleStatement(RuleStatement ruleStatement) {
		_tempRuleStatementList.add(ruleStatement);
	}
	
	public final void addRuleStatementDone() {
		_ruleStatements = (RuleStatement[]) _tempRuleStatementList.toArray(
			new RuleStatement[_tempRuleStatementList.size()]);
		_tempRuleStatementList.clear();
		_tempRuleStatementList = null;
	}
	
	public void execute(RuleContext ruleContext) throws SeasarException {
		try {
			for (int i = 0; i < _ruleStatements.length; ++i) {
				RuleStatement ruleStatement = _ruleStatements[i];
				ruleStatement.execute(ruleContext);
				if (ruleContext.isReturned() || ruleContext.isThrowed()) {
					return;
				}
			}
		} catch (Throwable t) {
			ruleContext.setThrowable(t, getLocation());
		}
	}
}
