package org.seasar.system;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Socket;
import java.util.Map;

import org.seasar.util.EMap;
import org.seasar.util.SeasarContext;
import org.seasar.util.SeasarException;

public final class RMIConnector {

	private static final int DUMMY = 0;
    private static Map _rmiAdaptors = new EMap();

    private RMIConnector() { }

	public static RMIAdaptor getRMIAdaptor(final SeasarContext seasarContext)
    		throws SeasarException {
    			
    	return getRMIAdaptor(seasarContext.getHostName(), seasarContext.getPort());
    }
    
	public static RMIAdaptor getRMIAdaptor(final String hostName, final int port)
    		throws SeasarException {

		if (port == 0) {
			return getRMIAdaptorBySocket("localhost", RMIAdaptorService.getInstance().getPort());
		}
    	String address = hostName + ":" + port;
    	RMIAdaptor rmiAdaptor = (RMIAdaptor) _rmiAdaptors.get(address);
    	if (rmiAdaptor != null) {
    		return rmiAdaptor;
    	}
    	synchronized (_rmiAdaptors) {
    		rmiAdaptor = (RMIAdaptor) _rmiAdaptors.get(address);
    		if (rmiAdaptor == null) {
    			rmiAdaptor = getRMIAdaptorBySocket(hostName, port);
    			_rmiAdaptors.put(address, rmiAdaptor);
    		}
    	}
    	return rmiAdaptor;
    }
    
    public static RMIAdaptor regetRMIAdaptor(final String hostName, final int port)
    		throws SeasarException {

		if (port == 0) {
			return getRMIAdaptorBySocket("localhost", RMIAdaptorService.getInstance().getPort());
		}
    	String address = hostName + ":" + port;
    	RMIAdaptor rmiAdaptor = null;
    	synchronized (_rmiAdaptors) {
			rmiAdaptor = getRMIAdaptorBySocket(hostName, port);
			_rmiAdaptors.put(address, rmiAdaptor);
    	}
    	return rmiAdaptor;
    }
    
    static void setRMIAdaptor(final String hostName, final int port,
    		final RMIAdaptor rmiAdaptor) {

    	String address = hostName + ":" + port;
    	_rmiAdaptors.put(address, rmiAdaptor);
    }

    public static RMIAdaptor getRMIAdaptorBySocket(String hostName, int port)
    		throws SeasarException {
    			
    	try {
        	Socket socket = new Socket(hostName, port);
        	try {
            	ObjectOutputStream out = new ObjectOutputStream(new BufferedOutputStream(socket.getOutputStream()));
            	out.writeInt(DUMMY);
            	out.flush();
            	ObjectInputStream in = new ObjectInputStream(new BufferedInputStream(socket.getInputStream()));
            	return (RMIAdaptor) in.readObject();
            
        	} finally {
            	if (socket != null) {
                	socket.close();
           		}
        	}
    	} catch (IOException ex) {
			throw new SeasarException("ESSR0040", new Object[]{ex}, ex);
		} catch (Exception ex) {
    		throw SeasarException.convertSeasarException(ex);
    	}
    }
}
