package test.org.seasar.nazuna;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;

import junit.framework.Test;
import junit.framework.TestSuite;

import org.seasar.nazuna.MapResultType;
import org.seasar.nazuna.Sqlet;
import org.seasar.util.SeasarContext;

import test.org.seasar.sql.ConnectionPoolTestCase;

public class MapResultTypeTest extends ConnectionPoolTestCase {

	public MapResultTypeTest(String name) {
		super(name);
	}

	public void testExecuteQuery() throws Exception {
		Connection con = null;
		Statement stmt = null;
		ResultSet rs = null;
		try {
			con = SeasarContext.getInstance().getConnection();
			stmt = con.createStatement();
			rs = stmt.executeQuery("select ename employeename from emp where empno = 7788");
			ResultSetMetaData rsMeta = rs.getMetaData();
			MapResultType mrt = MapResultType.create(rsMeta);
			assertEquals("1", "EMPLOYEENAME", mrt.getPropertyType(0).getColumnName()); 
		} finally {
			Sqlet.close(rs, stmt, con);
		}
	}

	protected void setUp() throws Exception {
		super.setUp();
	}

	protected void tearDown() throws Exception {
		super.tearDown();
	}

	public static Test suite() {
		return new TestSuite(MapResultTypeTest.class);
	}

	public static void main(String[] args) {
		junit.textui.TestRunner.main(
			new String[] { MapResultTypeTest.class.getName()});
	}
}