package test.org.seasar.sql;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import org.seasar.sql.ConnectionImpl;
import org.seasar.sql.XAConnectionImpl;
import org.seasar.sql.XADataSourceImpl;

public class ConnectionImplTest extends TestCase {

    private XAConnectionImpl _xaCon;
    private ConnectionImpl _con;

    public ConnectionImplTest(String name) {
        super(name);
    }

    public void testClose() throws Exception {
        _con.close();
        assertEquals("1", false, _con.isClosed());
        assertEquals("2", false, _xaCon.getPhysicalConnection().isClosed());
    }

    public void testAutoCommit() throws Exception {
        assertTrue("1", _con.getAutoCommit());
    }

    protected void setUp() throws Exception {
        XADataSourceImpl ds = new XADataSourceImpl();
        ds.setDriverClassName("oracle.jdbc.driver.OracleDriver");
        ds.setURL("jdbc:oracle:thin:@d1606:1521:ark");
        ds.setUser("ark");
        ds.setPassword("ark");
        _xaCon = (XAConnectionImpl)ds.getXAConnection();
        _con = (ConnectionImpl)_xaCon.getConnection();
    }

    protected void tearDown() throws Exception {
        _xaCon.close();
    }

    public static Test suite ( ) {
        return new TestSuite(ConnectionImplTest.class);
    }

    public static void main (String[] args) {
        junit.textui.TestRunner.main(new String[]{ConnectionImplTest.class.getName()});
    }
}