package test.org.seasar.system;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.Socket;

import junit.framework.TestCase;

import org.seasar.log.Logger;
import org.seasar.system.AbstractSocketService;

public class AbstractSocketServiceTest extends TestCase {

    private SocketService _socketService;
    private Socket _socket;
    private int _callCount = 0;


    public AbstractSocketServiceTest(String name) throws Exception {
        super(name);
    }



    public void testHandleSocket() throws Exception {
        BufferedReader reader = new BufferedReader(new InputStreamReader(_socket.getInputStream()));
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(_socket.getOutputStream()));
        String s = "test";
        String s2 = "test2";
        writer.write(s + System.getProperty("line.separator"));
        writer.flush();
        assertEquals("1", s, reader.readLine());
        assertEquals("2", s, _socketService._message);
    }

    protected void setUp() throws Exception {
        _socketService = new SocketService();
        _socketService.start();
        _socket = new Socket("localhost", _socketService.getPort());
    }

    protected void tearDown() throws Exception {
        _socket.close();
        _socketService.stop();
    }

    public static void main(String[] args) {
        junit.textui.TestRunner.main(new String[]{AbstractSocketServiceTest.class.getName()});
    }

    private class SocketService extends AbstractSocketService {

        private String _message;

        protected void handleSocket(Socket socket) throws IOException {
            BufferedReader reader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(socket.getOutputStream()));
            _message = reader.readLine();
            Logger.getLogger(getClass()).info(_message);
            writer.write(_message + System.getProperty("line.separator"));
            writer.flush();
        }
    }
}
