package test.org.seasar.system;

import junit.framework.Test;
import junit.framework.TestSuite;

import org.seasar.system.JMXService;
import org.seasar.system.JMXUtil;
import org.seasar.system.RMIAdaptor;
import org.seasar.system.RMIConnector;
import org.seasar.util.Serializer;

public class RMIAdaptorServiceAndConnectorTest extends RMIAdaptorTestCase {

	private static String HELLO_NAME = JMXUtil.getMBeanName("Hello");
	private static String THREAD_DUMP_NAME = JMXUtil.getMBeanName("TheadDump");

  	public RMIAdaptorServiceAndConnectorTest(String name) {
    	super(name);
  	}

  	public void testConnect() throws Throwable {
    	final int num = 1000;
    	Hello hello = new Hello();
    	JMXService.registerMBean(hello, HELLO_NAME);
    	RMIAdaptor rmiAdaptor = RMIConnector.getRMIAdaptorBySocket("localhost", _rmiAdaptorService.getPort());
    	Object copy = Serializer.serialize(rmiAdaptor);
    	assertEquals("1", "hello", rmiAdaptor.invoke(HELLO_NAME, "greeting", null, null));
    	long start = System.currentTimeMillis();
    	for (int i = 0; i < num; i++) {
      		rmiAdaptor.invoke(HELLO_NAME, "greeting", null, null);
    	}
    	System.out.println("RMIConnector millis:" + (System.currentTimeMillis() - start));
  	}
  	
  	public void testMultiThread() throws Throwable {
    	ThreadDump mbean = new ThreadDump();
    	JMXService.registerMBean(mbean, THREAD_DUMP_NAME);
    	    
    	RMIAdaptor rmiAdaptor = RMIConnector.getRMIAdaptor("localhost", _rmiAdaptorService.getPort());
    	ThreadDumpTester tester1 = new ThreadDumpTester("1", rmiAdaptor);
    	ThreadDumpTester tester2 = new ThreadDumpTester("2", rmiAdaptor);
    	tester1.start();
    	tester2.start();
    	while (tester1.isAlive() || tester2.isAlive()) {
    		Thread.sleep(10);
    	}
  	}

  	protected void setUp() throws Exception {
  		super.setUp();
  	}

  	protected void tearDown() throws Exception {
  		super.tearDown();
  	}

  	public static Test suite ( ) {
    	return new TestSuite(RMIAdaptorServiceAndConnectorTest.class);
  	}

  	public static void main (String[] args) {
    	junit.textui.TestRunner.main(new String[]{RMIAdaptorServiceAndConnectorTest.class.getName()});
  	}
  	
  	private class ThreadDumpTester extends Thread {
  		
  		private String _id;
  		private RMIAdaptor _rmiAdaptor;
  		private Object[] _args;
  		private String[] _argTypes = new String[]{"java.lang.String"};
  		
  		ThreadDumpTester(String id, RMIAdaptor rmiAdaptor) {
  			_id = id;
  			_rmiAdaptor = rmiAdaptor;
  			_args = new Object[]{id};
  		}
  		
  		public void run() {
  			final int num = 10;
  			try {
  				for (int i = 0; i < num; i++) {
  					_rmiAdaptor.invoke(THREAD_DUMP_NAME , "dump", _args, _argTypes);
  				}
  			} catch (Exception ex) {
  				ex.printStackTrace();
  			}
  		}
  	}
}