// Copyright 2002 Macromedia, Inc. and its licensors.  All Rights Reserved.
//
// Use and/or redistribution of this file, in whole or in part, is subject
// to the Macromedia Sample Files License, which was distributed with this file.
//
#initclip 
//
/*
  ToolTip
 
  This class exposes tooltip functionality to an arbitrary movie clip symbol.
 
  To use it:
 
  	1. Map the movie clip's onRollOver, onDragOver events to a function that
  	calls _global.toolTip_mc.prepare and maps onMouseMove to
  	_global.toolTip_mc.move.
  
  		my_mc.onRollOver = my_mc.onDragOver = prepareToolTip;
 
  		function prepareToolTip () {
  			_global.toolTip_mc.prepare(my_mc, "tip text", my_mc._xmouse, my_mc._ymouse); 
  			my_mc.onMouseMove = function() {
  				_global.toolTip_mc.move(this, this._xmouse, this._ymouse);
  				}
  		}
 
  
 
  	2. Map the movie clip's onRollOut and onDragOut events to a function that calls _global.toolTip_mc.hide
 
 		my_mc.onRollOut = my_mc.onDragOut = hideToolTip;
 
  		function hideToolTip () {
			delete my_mc.onMouseMove;
  			_global.toolTip_mc.hide();
  		}
 

	This file is associated with a library movie clip symbol.

	#include info for this file:

			FLA:				main.fla

			Layer:				Actions : Class

			Frame:				1

			Library Symbol:		toolTip_mc	

			Library Path:		/toolTip_mc

 */
//
//----------------------------------------------------------------------
//ToolTip
//----------------------------------------------------------------------
function ToolTip()
{
	this.label_txt.autoSize = "Left";
	this.label_txt.background = true;
	this.label_txt.backgroundColor = 0xB2B2B2;
	this.label_txt.border = true;
	this.label_txt.borderColor = 0x000000;
	this.label_txt.embedFonts = true;
	this.label_txt.wordWrap = false;
	this.label_txt.setTextFormat(_global.globalStyleFormatTextFormat_fmt);
	this.rhs = false;
	this._visible = false;
	_global.toolTip_mc = this;
	this.onEnterFrame = ToolTip.prototype.enterFrame;
	// create a reusable localToGlobal object
	this.l2gPt = new Object();
}

Object.registerClass("ToolTipSymbol", ToolTip);

ToolTip.prototype = new MovieClip();

//----------------------------------------------------------------------
// move
//
// Moves a tooltip with the mouse.
//----------------------------------------------------------------------
ToolTip.prototype.move = function(clip, clipParentX, clipParentY) {	
	this.l2gPt.x = clipParentX;
	this.l2gPt.y = clipParentY;
	clip.localToGlobal(this.l2gPt);
	this._x = (this.l2gPt.x + this._width <= stage.width) ? 
					this.l2gPt.x : this.l2gPt.x - this._width;
	this._y = this.l2gPt.y - this._height;
	updateAfterEvent();
}

//----------------------------------------------------------------------
// enterFrame
//
//  Determines whether mouse has hovered long enough over tooltip target and 
//  displays the tool tip when that occurs.
//----------------------------------------------------------------------
ToolTip.prototype.enterFrame = function() {
	if (this.waiting && (getTimer() >= this.showtime)) {
		this.waiting = false;
		this._visible = true;
		updateAfterEvent();
	}
}

//----------------------------------------------------------------------
// prepare
//
// Prepares a tooltip by setting its xy coordinates.
//----------------------------------------------------------------------
ToolTip.prototype.prepare = function (clip, tip, clipParentX, clipParentY) {
	this.showtime = 500 + getTimer();
	this.waiting = true;
	this.label_txt.text = tip;
	this.l2gPt.x = clipParentX;
	this.l2gPt.y = clipParentY;
	clip.localToGlobal(this.l2gPt);
	this._x = (this.l2gPt.x + this._width <= stage.width) ? 
					this.l2gPt.x : this.l2gPt.x - this._width;
	this._y = this.l2gPt.y - this._height;
}
	
//----------------------------------------------------------------------
// hide
//----------------------------------------------------------------------
ToolTip.prototype.hide = function () {
	this.waiting = false;
	this._visible = false;
}


#endinitclip
//Authors: Brian Kruse (bkruse), Buck Bito (bbito)
