// Copyright 2002 Macromedia, Inc. and its licensors.  All Rights Reserved.
//
// Use and/or redistribution of this file, in whole or in part, is subject
// to the Macromedia Sample Files License, which was distributed with this file.
//
#initclip 
//
//
/*
//
AdvertUI class

	The AdvertUI class encapsulates all UI behavior pertaining to context sensitive
	advertising during a browsing session.

	This is meant to be used as a singleton: i.e. It's not meant to be
	instantiated directly and all access should go through the _global.adWidget_mc
	object.

	This file is associated with a library movie clip symbol.

	#include info for this file:

			FLA:				main.fla

			Layer:				Actions : Class

			Frame:				1

			Library Symbol:		adWidget_mc

			Library Path:		widgetGroup/adWidget/adWidget_mc
//
*/
//

function AdvertUI() {
	_global.adWidget_mc	= this;
}

Object.registerClass("AdvertSymbol", AdvertUI);

AdvertUI.prototype = new MovieClip();

AdvertUI.prototype.init = function(strings) {
	this.strings = strings;
	this.isOpen = false;
	this.gotoAndStop("horizontal");
	this.adCopy_txt.text = this.strings.ADVERT_COPY_DEFAULT_str;
	this.currURL = _global.adImagePath_str + "homead.jpg"
	this.loadJPEG_mc.loadMovie(this.currURL);
}

AdvertUI.prototype.startListening = function() {
	seasar.event.Broadcaster.addEventListener("categoryChanged", this);
}

AdvertUI.prototype.categoryChangedPerformed = function(data) {
	this.gotoAndStop("vertical");
	this.adCopy_txt.text = this.strings.ADVERT_COPY_CONTEXT_str;
	var newURL = _global.adImagePath_str + data.catName + "ad.jpg";
	if (this.currURL != newURL) {
		this.currURL = newURL;
		this.loadJPEG_mc.loadMovie(newURL);
	}
}

#endinitclip