// Copyright 2002 Macromedia, Inc. and its licensors.  All Rights Reserved.
//
// Use and/or redistribution of this file, in whole or in part, is subject
// to the Macromedia Sample Files License, which was distributed with this file.
//
//----------------------------------------------------------------------
//
// utility function definitions
// 
//
/*
	This file contains functions only and is not associated with a movie clip.

	#include info for this file:

			FLA:				fui_components.fla

			Layer:				Actions : Utility Functions

			Frame:				1

			Library Symbol:		N/A (included on main timeline)

			Library Path:		
*/
//
//

//----------------------------------------------------------------------
//	_global.rsToComponent
//
//	This function is very similar to the DataGlue functions, except it
//	also selects an item.
//----------------------------------------------------------------------
_global.rsToComponent = function (component, recordSet, labelFld, dataFld, selectedOID)
{
	component.removeAll();
	var l = recordSet.getLength();
	var selectIndex = null;
	for (i=0; i<l; i++) {
		var anItem = recordSet.getItemAt(i);
		component.addItem(anItem[labelFld], anItem);
		if(selectedOID != null && selectedOID == anItem[dataFld]){
			selectIndex = i;
			selectedOID = null;
		}
	}
	return selectIndex;
}


//----------------------------------------------------------------------
//	_global.rsColumnToCurrency
//
//	This formats a column in a record set for currency display.
//----------------------------------------------------------------------
_global.rsColumnToCurrency = function(rs, colLabel)
{
	for (var i=0; i<rs.getLength(); i++) {
		var anItem = rs.getItemAt(i);
		anItem[colLabel] = _global.formatForCurrency(anItem[colLabel]);
		rs.setItemAt(i, anItem);
	}
	return rs;
}

// TRICKY: The two functions following are copied from the code for the
// PushButton component and simply have the enter key added

//----------------------------------------------------------------------
//	_global.buttonOnKeyDown
//----------------------------------------------------------------------
_global.buttonOnKeyDown = function( )
{
	if ((Key.getCode() == Key.ENTER || Key.getCode() == Key.SPACE) && this.pressOnce == undefined ) {
		this.onPress();
		this.pressOnce = 1;
	}
}

//----------------------------------------------------------------------
//	_global.buttonOnKeyUp
//----------------------------------------------------------------------
_global.buttonOnKeyUp = function( )
{
	if (Key.getCode() == Key.ENTER || Key.getCode() == Key.SPACE) {
		this.onRelease();
		this.pressOnce = undefined;
	}
}

//----------------------------------------------------------------------
//	_global.snapCoordToPixel
//
//	This function prevents antialiasing side effects by forcing component
//	drawing to take place on integer coordinates.
//----------------------------------------------------------------------
_global.snapCoordToPixel = function(coord, localScope)
{
	var point = new Object();
	point.x = point.y = coord;
	localScope.localToGlobal(point);
	var newCoord = coord + (Math.round(point.y) - point.y);
	return newCoord;
}
	

