#include "seasar/lang/SObject.as"
#include "seasar/event/Broadcaster.as"
#include "petmarket/service/cart/NewCartOid.as"
#include "petmarket/service/cart/GetShippingMethods.as"
	
if (petmarket.service.cart.Cart === undefined) {
	seasar.lang.SObject.defineClass("petmarket.service.cart.Cart", null,
		["cartoid", "newCartOid_svc", "shippingMethods"],
		function(conn) {
			this.newCartOid_svc = new petmarket.service.cart.NewCartOid(conn, this);
			this.getShippingMethods_svc = new petmarket.service.cart.GetShippingMethods(conn, this);
			
			this.shippingMethods = null;
			this.state_array = new Array();
			this.state_array.push("AL");
			this.state_array.push("AK");
			this.state_array.push("AR");
			this.state_array.push("AZ");
			this.state_array.push("CA");
			this.state_array.push("CO");
			this.state_array.push("CT");
			this.state_array.push("DC");
			this.state_array.push("DE");
			this.state_array.push("FL");
			this.state_array.push("GA");
			this.state_array.push("GU");
			this.state_array.push("HI");
			this.state_array.push("IA");
			this.state_array.push("ID");
			this.state_array.push("IL");
			this.state_array.push("IN");
			this.state_array.push("KS");
			this.state_array.push("KY");
			this.state_array.push("LA");
			this.state_array.push("MA");
			this.state_array.push("MD");
			this.state_array.push("ME");
			this.state_array.push("MI");
			this.state_array.push("MN");
			this.state_array.push("MO");
			this.state_array.push("MS");
			this.state_array.push("MT");
			this.state_array.push("NC");
			this.state_array.push("ND");
			this.state_array.push("NE");
			this.state_array.push("NH");
			this.state_array.push("NJ");
			this.state_array.push("NM");
			this.state_array.push("NV");
			this.state_array.push("NY");
			this.state_array.push("OH");
			this.state_array.push("OK");
			this.state_array.push("OR");
			this.state_array.push("PA");
			this.state_array.push("PR");
			this.state_array.push("RI");
			this.state_array.push("SC");
			this.state_array.push("SD");
			this.state_array.push("TN");
			this.state_array.push("TX");
			this.state_array.push("UT");
			this.state_array.push("VA");
			this.state_array.push("VI");
			this.state_array.push("VT");
			this.state_array.push("WA");
			this.state_array.push("WI");
			this.state_array.push("WV");
			this.state_array.push("WY");
			
			this.country_array = new Array();
			this.country_array.push("USA");
			
			this.creditCards_array = new Array();
			this.creditCards_array.push("American Express");
			this.creditCards_array.push("Discover/Novus");
			this.creditCards_array.push("MasterCard");
			this.creditCards_array.push("Visa");
		});
		
	var proto = petmarket.service.cart.Cart.prototype;
	
	proto.newCartOid = function() {
		this.newCartOid_svc.execute();
	}
	
	proto.getShippingMethodsServer = function() {
		this.getShippingMethods_svc.execute();
	}
	
	proto.addCartItem = function(itemRecord) {
		trace("addCartItem:" + itemRecord);
		seasar.event.Broadcaster.broadcast("addCartItem", itemRecord);
	}
	
	proto.getStates = function() {
		trace("getStates");
		return this.state_array;
	}
	
	proto.getCountries = function() {
		trace("getCountries");
		return this.country_array;
	}
	
	proto.getShippingMethods = function() {
		trace("getShippingMethods");
		return this.shippingMethods;
	}
	
	proto.getCreditCards = function() {
		trace("getCreditCards");
		return this.creditCards_array;
	}
	
	proto.doCheckout = function(cartMC) {
		trace("doCheckout");
		seasar.event.Broadcaster.broadcast("doCheckout", cartMC);
	}
	
	proto.continueShopping = function(resetToHome, needNewCart) {
		trace("continueShopping:resetToHome=" + resetToHome + ",needNewCart:" + needNewCart);
		var data = new Object();
		data.resetToHome = resetToHome != null ? resetToHome : false;
		data.needNewCart =  needNewCart != null ? needNewCart : false;
		seasar.event.Broadcaster.broadcast("continueShopping", data);
	}
	
	proto.updateTotalCost = function(total) {
		trace("updateTotalCost:total=" + total);
		seasar.event.Broadcaster.broadcast("updateTotalCost", total);
	}
	
	proto.applyDiscount = function (promoCode) {
		if (promoCode != null) {
			trace("applyDiscount:promoCode=" + promoCode);
			seasar.event.Broadcaster.broadcast("applyDiscount", promoCode.length);
		}
	}
	
	proto.setShippingCharge = function (amount) {
		if (amount != null) {
			trace("setShippingCharge:amount=" + amount);
			seasar.event.Broadcaster.broadcast("setShippingCharge", amount);
		}
	}

	delete proto;
}