#include "seasar/lang/SObject.as"
#include "seasar/event/Broadcaster.as"
#include "petmarket/service/catalog/GetCategories.as"
#include "petmarket/service/catalog/GetProducts.as"
#include "petmarket/service/catalog/SearchProducts.as"
#include "petmarket/service/catalog/GetItems.as"
	
if (petmarket.service.catalog.Catalog === undefined) {
	seasar.lang.SObject.defineClass("petmarket.service.catalog.Catalog", null,
		["getCategories_svc", "getProducts_svc", "searchProducts_svc",
		"getItems_svc"],
		function(conn) {
			this.getCategories_svc = new petmarket.service.catalog.GetCategories(conn);
			this.getProducts_svc = new petmarket.service.catalog.GetProducts(conn);
			this.searchProducts_svc = new petmarket.service.catalog.SearchProducts(conn);
			this.getItems_svc = new petmarket.service.catalog.GetItems(conn);
		});
		
	var proto = petmarket.service.catalog.Catalog.prototype;
	
	proto.getCategories = function() {
		this.getCategories_svc.execute();
	}
	
	proto.getProducts = function(categoryoid) {
		this.getProducts_svc.execute(categoryoid);
	}
	
	proto.searchProducts = function(str) {
		this.searchProducts_svc.execute(str);
	}
	
	proto.getItems = function(productoid) {
		this.getItems_svc.execute(productoid);
	}
	
	proto.categoryChanged = function (categoryOID, categoryName) {
		trace("categoryChanged:" + categoryOID + "," + categoryName);
		var data = { catOID : categoryOID, catName : categoryName};
		seasar.event.Broadcaster.broadcast("categoryChanged", data);
	}
	
	proto.browseNewProduct = function (newProduct, catLabel, catName, catColor) {
		trace("browseNewProduct:" + newProduct + "," + catLabel + "," + catName + "," + catColor);
		var data = { prod : newProduct, catLabel : catLabel , catName : catName, catColor : catColor};
		seasar.event.Broadcaster.broadcast("browseNewProduct", data);
	}
	
	proto.notifyProductAnimationComplete = function (prodRec, label, prodcolor) {
		trace("notifyProductAnimationComplete:" + prodRec + "," + label + "," + prodcolor);
		var data = { prodRec : prodRec, label : label, color : prodcolor };
		seasar.event.Broadcaster.broadcast("notifyProductAnimationComplete", data);
	}

	proto.changeSelectedProduct = function (categoryOID, productOID) {
		trace("changeSelectedProduct:" + categoryOID + "," + productOID);
		var data = { catOID : categoryOID, prodOID : productOID };
		seasar.event.Broadcaster.broadcast("changeSelectedProduct", data);
	};

	delete proto;
}