#include "seasar/lang/SObject.as"
#include "seasar/nazuna/RuleEventService.as"
#include "seasar/nazuna/NzRecordSet.as"
	
if (petmarket.service.user.GetUser === undefined) {
	seasar.lang.SObject.defineClass("petmarket.service.user.GetUser", seasar.nazuna.RuleEventService,
		"user",
		function(conn, user) {
			super(conn, "petmarket.rule.user.GetUser", "getUser", "getUserStatus");
			this.user = user;
		});
		
	var proto = petmarket.service.user.GetUser.prototype;
	
	proto.execute = function(email, passwd) {
		trace("getUser:email=" + email);
		this.rule.execute(email, passwd);
	}
	
	proto.onResult = function(userData) {
		this.user.userData = userData;
		super.onResult(userData);
	}
	
	proto.onStatus = function(userData) {
		this.user.userData = null;
		super.onStatus(userData);
	}
	
	delete proto;
}