#include "NetServices.as"
#include "seasar/lang/SObject.as"
#include "seasar/unit/TestCase.as"
#include "seasar/event/Broadcaster.as"
#include "petmarket/service/catalog/GetItems.as"

if (test.petmarket.service.catalog.GetItemsTest === undefined) {
	seasar.lang.SObject.defineClass("test.petmarket.service.catalog.GetItemsTest",
		seasar.unit.TestCase, ["service"]);
	
	var proto = test.petmarket.service.catalog.GetItemsTest.prototype;
	
	proto.setUp = function() {
		NetServices.setDefaultGatewayUrl("http://localhost:8080/petmarket/gateway");
		var conn = NetServices.createGatewayConnection();
		this.service = new petmarket.service.catalog.GetItems(conn);
	}
	
	proto.tearDown = function() {
		this.service = null;
	}
	
	proto.testExecute = function() {
		var listener = new Object();
		listener.getItemsPerformed = function(data) {
			trace("listener.getItemsPerformed:" + data.getLength());
		}
		seasar.event.Broadcaster.addEventListener("getItems", listener);
		this.service.execute(96);
	}

	delete proto;
}