#include "NetServices.as"
#include "seasar/lang/SObject.as"
#include "seasar/unit/TestCase.as"
#include "seasar/event/Broadcaster.as"
#include "petmarket/service/user/User.as"
#include "petmarket/service/user/UpdateUser.as"

if (test.petmarket.service.user.UpdateUserTest === undefined) {
	seasar.lang.SObject.defineClass("test.petmarket.service.user.UpdateUserTest",
		seasar.unit.TestCase, ["user", "service"]);
	
	var proto = test.petmarket.service.user.UpdateUserTest.prototype;
	
	proto.setUp = function() {
		NetServices.setDefaultGatewayUrl("http://localhost:8080/petmarket/gateway");
		var conn = NetServices.createGatewayConnection();
		this.user = new petmarket.service.user.User(conn);
		this.service = new petmarket.service.user.UpdateUser(conn, this.user);
	}
	
	proto.tearDown = function() {
		this.user = null;
		this.service = null;
	}
	
	proto.testExecute = function() {
		var listener = new Object();
		listener.updateUserPerformed = function(data) {
			trace("listener.updateUserPerformed");
		}
		seasar.event.Broadcaster.addEventListener("updateUser", listener);
		this.user.userData = new Object();
		this.user.userData.useroid = 0;
		this.user.userData.email = "higa@isid.co.jp";
		this.user.userData.password = "yasuo";
		this.service.execute();
	}

	delete proto;
}