package org.seasar.system;

import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;

import javax.management.Notification;
import javax.management.NotificationListener;

import org.seasar.util.SeasarContext;
import org.seasar.util.SeasarException;
import org.seasar.util.SeasarRuntimeException;

public class RMINotificationListenerAdaptor implements RMINotificationListener {
	
	private String _targetName;
	private NotificationListener _notificationListener;
	private SeasarContext _seasarContext;
	private RMINotificationListener _rmiNotificationListenerStub;
	private RMIAdaptor _rmiAdaptor;
	private String _listenerName;
	
	public RMINotificationListenerAdaptor(String targetName,
			NotificationListener notificationListener, SeasarContext seasarContext) {
				
		if (targetName == null) {
			throw new SeasarRuntimeException("ESSR0007", new Object[]{"targetName"});
		}
		_targetName = targetName;
		if (notificationListener == null) {
			throw new SeasarRuntimeException("ESSR0007", new Object[]{"notificationListener"});
		}
		_notificationListener = notificationListener;
		if (seasarContext == null) {
			throw new SeasarRuntimeException("ESSR0007", new Object[]{"seasarContext"});
		}
		_seasarContext = seasarContext;
	}
	
	public void addNotificationListener() throws SeasarException {
		try {
			_rmiNotificationListenerStub = (RMINotificationListener)
	    		UnicastRemoteObject.exportObject(this);
	    	_rmiAdaptor = RMIConnector.getRMIAdaptor(_seasarContext);
			_listenerName = _rmiAdaptor.addNotificationListener(_targetName, _rmiNotificationListenerStub);
		} catch (RemoteException ex) {
			throw SeasarException.convertSeasarException(ex);
		}
	}
	
	public void removeNotificationListener() throws SeasarException {
		try {
			_rmiAdaptor.removeNotificationListener(_listenerName);
			UnicastRemoteObject.unexportObject(this, false);
		} catch (RemoteException ex) {
			throw SeasarException.convertSeasarException(ex);
		}
	}

	public void handleRMINotification(Notification notification, Object handback) {
		_notificationListener.handleNotification(notification, handback);
	}
	
	public String getListenerName() {
		return _listenerName;
	}	
}
