package org.seasar.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;

public final class Conversion {

	private Conversion() {
	}
	
	public static BigDecimal toBigDecimal(Object o) {
		return toBigDecimal(o, null);
	}
	
	public static BigDecimal toBigDecimal(Object o, String pattern) {
		if (o == null) {
            return null;
        } else if (o instanceof BigDecimal) {
            return (BigDecimal) o;
		} else if (o instanceof Number) {
            return new BigDecimal(((Number) o).doubleValue());
        } else if (o instanceof String) {
            return new BigDecimal((String) o);
        } else if (o instanceof java.util.Date) {
        	if (pattern != null) {
            	return new BigDecimal(new SimpleDateFormat(pattern).format(o));
        	} else {
        		return new BigDecimal(((java.util.Date) o).getTime());
        	}
        } else {
            return new BigDecimal(o.toString());
        }
	}
	
	public static Double toDouble(Object o) {
		return toDouble(o, null);
	}
	
	public static Double toDouble(Object o, String pattern) {
		if (o == null) {
            return null;
        } else if (o instanceof Double) {
            return (Double) o;
		} else if (o instanceof Number) {
            return new Double(((Number) o).doubleValue());
        } else if (o instanceof String) {
            return Double.valueOf((String) o);
        } else if (o instanceof java.util.Date) {
        	if (pattern != null) {
            	return new Double(new SimpleDateFormat(pattern).format(o));
        	} else {
        		return new Double(((java.util.Date) o).getTime());
        	}
        } else {
            return new Double(o.toString());
        }
	}
	
	public static Float toFloat(Object o) {
		return toFloat(o, null);
	}
	
	public static Float toFloat(Object o, String pattern) {
		if (o == null) {
            return null;
        } else if (o instanceof Float) {
            return (Float) o;
		} else if (o instanceof Number) {
            return new Float(((Number) o).floatValue());
        } else if (o instanceof String) {
            return Float.valueOf((String) o);
        } else if (o instanceof java.util.Date) {
        	if (pattern != null) {
            	return new Float(new SimpleDateFormat(pattern).format(o));
        	} else {
        		return new Float(((java.util.Date) o).getTime());
        	}
        } else {
            return new Float(o.toString());
        }
	}
	
	public static Long toLong(Object o) {
		return toLong(o, null);
	}
	
	public static Long toLong(Object o, String pattern) {
		if (o == null) {
            return null;
        } else if (o instanceof Long) {
            return (Long) o;
		} else if (o instanceof Number) {
            return new Long(((Number) o).longValue());
        } else if (o instanceof String) {
            return new Long((String) o);
        } else if (o instanceof java.util.Date) {
        	if (pattern != null) {
            	return new Long(new SimpleDateFormat(pattern).format(o));
        	} else {
        		return new Long(((java.util.Date) o).getTime());
        	}
        } else {
            return new Long(o.toString());
        }
	}
	
	public static Integer toInteger(Object o) {
		return toInteger(o, null);
	}
	
	public static Integer toInteger(Object o, String pattern) {
		if (o == null) {
            return null;
        } else if (o instanceof Integer) {
            return (Integer) o;
        } else if (o instanceof Number) {
            return new Integer(((Number) o).intValue());
        } else if (o instanceof String) {
            return new Integer((String) o);
        } else if (o instanceof java.util.Date) {
        	if (pattern != null) {
            	return new Integer(new SimpleDateFormat(pattern).format(o));
        	} else {
        		return new Integer((int) ((java.util.Date) o).getTime());
        	}
        } else {
            return new Integer(o.toString());
        }
	}
	
	public static Short toShort(Object o) {
		return toShort(o, null);
	}
	
	public static Short toShort(Object o, String pattern) {
		if (o == null) {
            return null;
        } else if (o instanceof Short) {
            return (Short) o;
		} else if (o instanceof Number) {
            return new Short(((Number) o).shortValue());
        } else if (o instanceof String) {
            return Short.valueOf((String) o);
        } else if (o instanceof java.util.Date) {
        	if (pattern != null) {
            	return new Short(new SimpleDateFormat(pattern).format(o));
        	} else {
        		return new Short((short) ((java.util.Date) o).getTime());
        	}
        } else {
            return new Short(o.toString());
        }
	}
	
	public static Number toNumber(String s) {
		if (StringUtil.isEmpty(s)) {
            return null;
        }
        s = s.trim();
        char[] charArray = s.toCharArray();
        int index = 0;
        boolean neg = false;
        char c = charArray[index];
	    if (c == '-') {
			c = charArray[++index];
			if (c != '.' && (c < '0' || c > '9')) {
		    	throw new SeasarRuntimeException("ESSR0346", new Object[]{s});
			}
			neg = true;
	    }
	    long v = 0;
	    int decexp = 0;
	    int seendot = 0;
	    while (true) {
			if (c == '.' && seendot == 0) {
		    	seendot = 1;
			} else if ('0' <= c && c <= '9') {
		    	v = v * 10 + (c - '0');
		    	decexp += seendot;
			} else {
		    	break;
			}
			if (index >= charArray.length - 1) {
				break;
			}
			c = charArray[++index];
	    }
	    long v2 = neg ? -v : v;
	    if (decexp != 0) {
	    	return new BigDecimal(BigInteger.valueOf(v2), decexp);
	    }
	    if (v2 > Integer.MAX_VALUE || v2 < Integer.MIN_VALUE) {
	    	return new Long(v2);
	    }
	    int v3 = (int) v;
	    v3 = neg ? -v3 : v3;
	    return new Integer(v3);
	}
	
	public static Timestamp toTimestamp(Object o) {
		return toTimestamp(o, null);
	}
	
	public static Timestamp toTimestamp(Object o, String pattern) {
		if (o == null) {
            return null;
        } else if (o instanceof String) {
            return new Timestamp(toDate((String) o, pattern).getTime());
        } else if (o instanceof java.util.Date) {
        	return new Timestamp(((java.util.Date) o).getTime());
        } else if (o instanceof BigDecimal) {
            return new Timestamp(((BigDecimal) o).longValue());
        } else if (o instanceof Long) {
            return new Timestamp(((Long) o).longValue());
		} else if (o instanceof Integer) {
            return new Timestamp(((Integer) o).longValue());
        } else {
            return new Timestamp(toDate(o.toString(), pattern).getTime());
        }
	}
	
	public static String toString(Object value) {
		return toString(value, null);
	}
	
	public static String toString(Object value, String pattern) {
        if (value == null) {
            return null;
        } else if (value instanceof String) {
            return (String) value;
        } else if (value instanceof java.util.Date) {
        	return toString((java.util.Date) value, pattern);
        } else if (value instanceof Number) {
            return toString((Number) value, pattern);
        } else {
            return value.toString();
        }
    }
    
	public static String toString(Number value, String pattern) {
        if (value != null) {
            if (pattern != null) {
                return new DecimalFormat(pattern).format(value);
            } else {
                return value.toString();
            }
        } else {
            return null;
        }
    }
    
    public static String toString(java.util.Date value, String pattern) {
        if (value != null) {
            if (pattern != null) {
                return getSimpleDateFormat(pattern).format(value);
            } else {
                return value.toString();
            }
        } else {
            return null;
        }
    }
    
    public static byte[] toByteArray(Object o) {
        if (o instanceof byte[]) {
            return (byte[])o;
        } else if (o == null) {
            return null;
        } else {
            if (o instanceof String) {
                return ((String) o).getBytes();
            } else {
                throw new SeasarRuntimeException("ESSR0027", new Object[]{o});
            }
        }
    }

	public static boolean toBoolean(String name) { 
		return ((name != null) && name.equalsIgnoreCase("true"));
    }
	
	private static java.util.Date toDate(String s, String pattern) {
		try {
			SimpleDateFormat sdf = getSimpleDateFormat(pattern);
            return new Timestamp(sdf.parse(s).getTime());
		} catch (ParseException ex) {
			throw SeasarRuntimeException.convertSeasarRuntimeException(ex);
		}
	}
	
	private static SimpleDateFormat getSimpleDateFormat(String pattern) {
		SimpleDateFormat sdf = null;
       	if (pattern != null) {
        	sdf = new SimpleDateFormat(pattern);
        } else {
        	sdf = new SimpleDateFormat();
        }
        sdf.setLenient(false);
        return sdf;
	}
}
