package org.seasar.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;

public final class ThrowableUtil {

    private ThrowableUtil() {
    }
    
    public static Throwable getCause(final Throwable throwable) {
        if (throwable instanceof UndeclaredThrowableException) {
        	Throwable t = ((UndeclaredThrowableException) throwable).getUndeclaredThrowable();
        	return getCause(t);
        }
		if (throwable instanceof InvocationTargetException) {
			Throwable t = ((InvocationTargetException) throwable).getTargetException();
			return getCause(t);
		}
        if (throwable instanceof SeasarException) {
        	SeasarException se = (SeasarException) throwable;
        	if (se.getMessageCode().equals("ESSR0017")) {
        		return getCause(se.getCause());
        	}
        } else if (throwable instanceof SeasarRuntimeException) {
        	SeasarRuntimeException sre = (SeasarRuntimeException) throwable;
        	if (sre.getMessageCode().equals("ESSR0017")) {
        		return getCause(sre.getCause());
        	}
        }
        return throwable;
    }
    
    public static StackTraceElement getCallerCallerStackTraceElement(
    		Throwable throwable, Class callerClass) {
    		
    	StackTraceElement[] stea = throwable.getStackTrace();
    	for (int i = 0; i < stea.length; ++i) {
    		if (!stea[i].getClassName().equals(callerClass.getName())) {
    			return stea[i];
    		}
    		continue;
    	}
    	throw new IllegalArgumentException(callerClass.getName() + " not found");
	}
	
	public static String getStackTraceString(Throwable t) {
    	StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        return sw.toString();
    }
}