package org.seasar.extension.dataset.impl;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;

import org.seasar.extension.dataset.types.ColumnTypes;
import org.seasar.extension.jdbc.PropertyType;
import org.seasar.extension.jdbc.ValueType;
import org.seasar.extension.jdbc.impl.AbstractPropertyHandler;
import org.seasar.extension.jdbc.impl.PropertyTypeImpl;

public class DataColumnPropertyHandler extends AbstractPropertyHandler {

	public DataColumnPropertyHandler() {
	}

	public PropertyType[] createPropertyTypes(ResultSetMetaData rsmd)
		throws SQLException {

		int count = rsmd.getColumnCount();
		PropertyType[] propertyTypes = new PropertyType[count];
		for (int i = 0; i < count; ++i) {
			String propertyName = getPropertyName(rsmd, i + 1);
			ValueType valueType = ColumnTypes.getValueType(
				rsmd.getColumnType(i + 1));
			propertyTypes[i] = new PropertyTypeImpl(propertyName, valueType);
		}
		return propertyTypes;
	}
}
