package org.seasar.framework.container.impl;

import org.seasar.framework.container.S2Container;
import org.seasar.framework.sel.SelContext;
import org.seasar.framework.sel.TargetOfPropertyNotFoundRuntimeException;
import org.seasar.framework.sel.util.PropertyUtil;

/**
 * @author higa
 *
 */
public class S2ContainerSelContext implements SelContext {

	private S2Container container_;
	private Object this_;

	/**
	 * 
	 */
	public S2ContainerSelContext(S2Container container) {
		container_ = container;
	}

	/**
	 * @see org.seasar.framework.sel.SelContext#getVariable(java.lang.String)
	 */
	public Object getVariable(String name) {
		if ("this".equals(name)) {
			return this_;
		} else {
			return container_.getComponent(name);
		}
	}

	/**
	 * @see org.seasar.framework.sel.SelContext#setVariable(java.lang.String, java.lang.Object)
	 */
	public void setVariable(String name, Object value) {
		if ("this".equals(name)) {
			this_ = value;
		} else {
			throw new UnsupportedOperationException("setVariable");
		}
	}

	/**
	 * @see org.seasar.framework.sel.SelContext#getProperty(java.lang.Object, java.lang.String)
	 */
	public Object getProperty(Object variable, String propertyName)
		throws TargetOfPropertyNotFoundRuntimeException {

		return PropertyUtil.getProperty(variable, propertyName);
	}

}
