package org.seasar.framework.sel.exps;

import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.factory.BeanDescFactory;
import org.seasar.framework.sel.Expression;
import org.seasar.framework.sel.SelContext;
import org.seasar.framework.sel.util.SelContextUtil;

public final class StaticMethodExp implements Expression {

	private Class targetClass_;
	private String methodName_;
	private Expression[] exps_;

	public StaticMethodExp(
		Class targetClass,
		String methodName,
		Expression[] exps) {

		targetClass_ = targetClass;
		methodName_ = methodName;
		exps_ = exps;
	}

	public Object evaluateValue(SelContext context) {
		Object[] args = SelContextUtil.evaluateValues(context, exps_);
		BeanDesc beanDesc = BeanDescFactory.getBeanDesc(targetClass_);
		return beanDesc.invoke(null, methodName_, args);
	}
}
