package org.seasar.framework.sel.util;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.Map;

import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.PropertyDesc;
import org.seasar.framework.beans.factory.BeanDescFactory;
import org.seasar.framework.sel.TargetOfPropertyNotFoundRuntimeException;
import org.seasar.framework.util.FieldUtil;

/**
 * @author higa
 *
 */
public class PropertyUtil {

	private PropertyUtil() {
	}

	public static Object getProperty(Object target, String propertyName) {
		if (target == null) {
			throw new TargetOfPropertyNotFoundRuntimeException(propertyName);
		}
		if (target instanceof Map) {
			return ((Map) target).get(propertyName);
		} else if (
			target.getClass().isArray() && "length".equals(propertyName)) {
			return new Integer(Array.getLength(target));
		} else {
			BeanDesc beanDesc = BeanDescFactory.getBeanDesc(target.getClass());
			if (beanDesc.hasPropertyDesc(propertyName)) {
				PropertyDesc propertyDesc =
					beanDesc.getPropertyDesc(propertyName);
				return propertyDesc.getValue(target);
			} else {
				Field field = beanDesc.getField(propertyName);
				return FieldUtil.get(field, target);
			}

		}
	}

	public static void setProperty(
		Object target,
		String propertyName,
		Object value) {

		if (target == null) {
			throw new TargetOfPropertyNotFoundRuntimeException(propertyName);
		}
		if (target instanceof Map) {
			((Map) target).put(propertyName, value);
		} else {
			BeanDesc beanDesc = BeanDescFactory.getBeanDesc(target.getClass());
			PropertyDesc propertyDesc = beanDesc.getPropertyDesc(propertyName);
			propertyDesc.setValue(target, value);
		}
	}

}
