package org.seasar.framework.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

import org.seasar.framework.exception.IllegalAccessRuntimeException;
import org.seasar.framework.exception.InstantiationRuntimeException;
import org.seasar.framework.exception.InvocationTargetRuntimeException;

/**
 * @author higa
 *
 */
public final class MethodUtil {

	/**
	 * 
	 */
	private MethodUtil() {
	}

	public static Object invoke(Method method, Object target, Object[] args)
		throws InstantiationRuntimeException, IllegalAccessRuntimeException {

		try {
			return method.invoke(target, args);
		} catch (InvocationTargetException ex) {
			throw new InvocationTargetRuntimeException(
				method.getDeclaringClass(),
				ex);
		} catch (IllegalAccessException ex) {
			throw new IllegalAccessRuntimeException(
				method.getDeclaringClass(),
				ex);
		}
	}

	public static String getSignature(String methodName, Class[] argTypes) {
		StringBuffer buf = new StringBuffer(100);
		buf.append(methodName);
		buf.append("(");
		if (argTypes != null) {
			for (int i = 0; i < argTypes.length; ++i) {
				if (i > 0) {
					buf.append(", ");
				}
				buf.append(argTypes[i].getName());
			}
		}
		buf.append(")");
		return buf.toString();
	}

	public static String getSignature(String methodName, Object[] methodArgs) {
		StringBuffer buf = new StringBuffer(100);
		buf.append(methodName);
		buf.append("(");
		if (methodArgs != null) {
			for (int i = 0; i < methodArgs.length; ++i) {
				if (i > 0) {
					buf.append(", ");
				}
				if (methodArgs[i] != null) {
					buf.append(methodArgs[i].getClass().getName());
				} else {
					buf.append("null"); 
				}
			}
		}
		buf.append(")");
		return buf.toString();
	}
}
