package test.org.seasar.extension.unit;

import java.math.BigDecimal;

import org.seasar.extension.dataset.DataRow;
import org.seasar.extension.dataset.DataSet;
import org.seasar.extension.dataset.DataTable;
import org.seasar.extension.unit.S2TestCase;

public class S2TestCaseTest extends S2TestCase {

	private boolean testAaaSetUpInvoked_ = false;
	
	public S2TestCaseTest(String arg0) {
		super(arg0);
	}

	public static void main(String[] args) {
		junit.textui.TestRunner.run(S2TestCaseTest.class);
	}

	public void setUpAaa() {
		testAaaSetUpInvoked_ = true;
	}
	
	public void testAaa() {
		assertEquals("1", true, testAaaSetUpInvoked_);
	}
	
	public void tearDownAaa() {
		System.out.println("tearDownAaa");
	}
	
	public void setUpBbbTx() {
		include("j2ee-config.xml");
	}

	public void testBbbTx() {
		System.out.println("testBbbTx");
	}
	
	public void setUpGetDataSource() {
		include("j2ee-config.xml");
	}

	public void testGetDataSource() {
		assertNotNull("1", getDataSource());
	}
	
	public void testReadXls() {
		DataSet dataSet = readXls("testdata.xls");
		System.out.println(dataSet);
		assertEquals("1", 2, dataSet.getTableSize());
		DataTable table = dataSet.getTable("emp");
		assertEquals("2", 2, table.getRowSize());
		assertEquals("3", 3, table.getColumnSize());
		DataRow row = table.getRow(0);
		assertEquals("4", new BigDecimal(9900), row.getValue("empno"));
		assertEquals("5", "hoge", row.getValue("ename"));
		assertEquals("6", "aaa", row.getValue("dname"));
	}
	
	public void setUpWriteDbTx() {
		include("j2ee-config.xml");
	}

	public void testWriteDbTx() {
		DataSet dataSet = readXls("testdata.xls");
		writeDb(dataSet);
	}
	
	public void setUpReadDbByTable() {
		include("j2ee-config.xml");
	}
	
	public void testReadDbByTable() {
		DataTable table = readDbByTable("emp", "empno = 7788");
		System.out.println(table);
		assertEquals("1", 1, table.getRowSize());
	}
	
	public void setUpReadDbBySql() {
		include("j2ee-config.xml");
	}

	public void testReadDbBySql() {
		DataTable table = readDbBySql("SELECT * FROM emp WHERE empno = 7788", "emp");
		System.out.println(table);
		assertEquals("1", 1, table.getRowSize());
	}

	public void testWriteXls() {
		DataSet dataSet = readXls("testdata.xls");
		writeXls("aaa.xls", dataSet);
		DataSet dataSet2 = readXls("aaa.xls");
		assertEquals("1", dataSet, dataSet2);
	}
}
