package test.org.seasar.framework.sel.exps;

import java.util.ArrayList;
import java.util.List;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import org.seasar.framework.sel.Expression;
import org.seasar.framework.sel.exps.ConcatenateExp;
import org.seasar.framework.sel.exps.ObjectExp;
import org.seasar.framework.sel.util.ExpressionUtil;

public class ConcatenateExpTest extends TestCase {

	public ConcatenateExpTest(String name) {
		super(name);
	}

	public void testEvaluate() throws Exception {
		List exps = new ArrayList();
		exps.add(new ObjectExp("aaa"));
		exps.add(new ObjectExp(new Integer(111)));
		Expression exp =
			new ConcatenateExp(ExpressionUtil.toExpressionArray(exps));
		assertEquals("1", "aaa111", exp.evaluateValue(null));
	}

	protected void setUp() throws Exception {
	}

	protected void tearDown() throws Exception {
	}

	public static Test suite() {
		return new TestSuite(ConcatenateExpTest.class);
	}

	public static void main(String[] args) {
		junit.textui.TestRunner.main(
			new String[] { ConcatenateExpTest.class.getName()});
	}
}