package test.org.seasar.framework.sel.exps;

import java.math.BigDecimal;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import org.seasar.framework.sel.exps.BigDecimalExp;
import org.seasar.framework.sel.exps.DivideExp;
import org.seasar.framework.sel.exps.ObjectExp;

public class DivideExpTest extends TestCase {

	public DivideExpTest(String name) {
		super(name);
	}

	public void testDivide() throws Exception {
		ObjectExp i1Exp = new ObjectExp(new Integer(5));
		ObjectExp i2Exp = new ObjectExp(new Integer(2));
		DivideExp exp = new DivideExp(i1Exp, i2Exp);
		assertEquals("1", new Integer(2), exp.evaluateValue(null));
	}

	public void testDivide2() throws Exception {
		ObjectExp long1Exp = new ObjectExp(new Long(5));
		ObjectExp long2Exp = new ObjectExp(new Long(2));
		DivideExp exp = new DivideExp(long1Exp, long2Exp);
		assertEquals("1", new Long(2), exp.evaluateValue(null));
	}

	public void testDivide3() throws Exception {
		BigDecimalExp decimal1Exp = new BigDecimalExp(new BigDecimal(5));
		BigDecimalExp decimal2Exp = new BigDecimalExp(new BigDecimal(2));
		DivideExp exp = new DivideExp(decimal1Exp, decimal2Exp);
		assertEquals("1", new BigDecimal(2.5), exp.evaluateValue(null));
	}

	protected void setUp() throws Exception {
	}

	protected void tearDown() throws Exception {
	}

	public static Test suite() {
		return new TestSuite(DivideExpTest.class);
	}

	public static void main(String[] args) {
		junit.textui.TestRunner.main(
			new String[] { DivideExpTest.class.getName()});
	}
}