package test.org.seasar.framework.sel.exps;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import org.seasar.framework.sel.SelContext;
import org.seasar.framework.sel.VariableNotFoundRuntimeException;
import org.seasar.framework.sel.context.SelContextImpl;
import org.seasar.framework.sel.exps.GetVariableExp;

public class GetVariableExpTest extends TestCase {

	public GetVariableExpTest(String name) {
		super(name);
	}

	public void testEvaluateValue() throws Exception {
		SelContext ctx = new SelContextImpl();
		MyBean myBean = new MyBean();
		ctx.setVariable("mybean", myBean);
		GetVariableExp exp = new GetVariableExp("mybean");
		assertSame("1", myBean, exp.evaluateValue(ctx));
	}
	
	public void testEvaluateValue2() throws Exception {
		SelContext ctx = new SelContextImpl();
		MyBean myBean = new MyBean();
		ctx.setVariable("mybean", myBean);
		GetVariableExp exp = new GetVariableExp("\"mybean\"");
		assertSame("1", myBean, exp.evaluateValue(ctx));
	}
	
	public void testEvaluateValue3() throws Exception {
		SelContext ctx = new SelContextImpl();
		GetVariableExp exp = new GetVariableExp("\"mybean\"");
		try {
			exp.evaluateValue(ctx);
			fail("1");
		} catch (VariableNotFoundRuntimeException ex) {
			System.out.println(ex);
		}
	}

	protected void setUp() throws Exception {
	}

	protected void tearDown() throws Exception {
	}

	public static Test suite() {
		return new TestSuite(GetVariableExpTest.class);
	}

	public static void main(String[] args) {
		junit.textui.TestRunner.main(
			new String[] { GetVariableExpTest.class.getName()});
	}

	public static class MyBean {

		private String _aaa = "test";

		public String getAaa() {
			return _aaa;
		}
	}
}