package test.org.seasar.framework.sel.exps;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import org.seasar.framework.sel.Expression;
import org.seasar.framework.sel.exps.MethodExp;
import org.seasar.framework.sel.exps.ObjectExp;
import org.seasar.framework.sel.util.ExpressionUtil;

public class MethodExpTest extends TestCase {

	public MethodExpTest(String name) {
		super(name);
	}

	public static String foo(Object o) {
		return o.toString();
	}

	public void testEvaluateValue() throws Exception {
		Expression exp =
			new MethodExp(
				new ObjectExp("abc"),
				"toUpperCase",
				ExpressionUtil.EMPTY_EXPRESSIONS);
		assertEquals("1", "ABC", exp.evaluateValue(null));
	}

	protected void setUp() throws Exception {
	}

	protected void tearDown() throws Exception {
	}

	public static Test suite() {
		return new TestSuite(MethodExpTest.class);
	}

	public static void main(String[] args) {
		junit.textui.TestRunner.main(
			new String[] { MethodExpTest.class.getName()});
	}
}