package test.org.seasar.framework.sel.exps;

import java.util.ArrayList;
import java.util.List;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import org.seasar.framework.sel.Expression;
import org.seasar.framework.sel.exps.NewArrayExp;
import org.seasar.framework.sel.exps.ObjectExp;
import org.seasar.framework.sel.util.ExpressionUtil;

public class NewArrayExpTest extends TestCase {

	public NewArrayExpTest(String name) {
		super(name);
	}

	public void testEvaluateValue() throws Exception {
		Expression exp =
			new NewArrayExp(
				String.class,
				new ObjectExp(new Integer(2)),
				ExpressionUtil.EMPTY_EXPRESSIONS);
		String[] ret = (String[]) exp.evaluateValue(null);
		assertEquals("1", 2, ret.length);
	}

	public void testEvaluateValue2() throws Exception {
		List argExpList = new ArrayList();
		argExpList.add(new ObjectExp("aaa"));
		argExpList.add(new ObjectExp("bbb"));
		Expression exp =
			new NewArrayExp(
				String.class,
				new ObjectExp(new Integer(2)),
				ExpressionUtil.toExpressionArray(argExpList));
		String[] ret = (String[]) exp.evaluateValue(null);
		assertEquals("1", 2, ret.length);
		assertEquals("2", "aaa", ret[0]);
		assertEquals("3", "bbb", ret[1]);
	}

	protected void setUp() throws Exception {
	}

	protected void tearDown() throws Exception {
	}

	public static Test suite() {
		return new TestSuite(NewArrayExpTest.class);
	}

	public static void main(String[] args) {
		junit.textui.TestRunner.main(
			new String[] { NewArrayExpTest.class.getName()});
	}
}