package test.org.seasar.framework.sel.util;

import java.util.HashMap;
import java.util.Map;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import org.seasar.framework.sel.TargetOfPropertyNotFoundRuntimeException;
import org.seasar.framework.sel.util.PropertyUtil;

public class PropertyUtilTest extends TestCase {

	public static final String HOGE = "hoge";
	
	public PropertyUtilTest(String name) {
		super(name);
	}

	public void testGetPropertyForMap() throws Exception {
		Map aaa = new HashMap();
		aaa.put("bbb", "hoge");
		assertEquals("1", "hoge", PropertyUtil.getProperty(aaa, "bbb"));
	}

	public void testGetPropertyForBean() throws Exception {
		Aaa aaa = new Aaa();
		assertEquals("1", "hoge", PropertyUtil.getProperty(aaa, "bbb"));
	}
	
	public void testGetPropertyForField() throws Exception {
		assertEquals("1", "hoge", PropertyUtil.getProperty(this, "HOGE"));
	}

	public void testGetPropertyForError() throws Exception {
		try {
			PropertyUtil.getProperty(null, "hoge");
		} catch (TargetOfPropertyNotFoundRuntimeException ex) {
			System.out.println(ex);
		}
	}
	
	public void testSetPropertyForMap() throws Exception {
		Map aaa = new HashMap();
		PropertyUtil.setProperty(aaa, "bbb", "hoge");
		assertEquals("1", "hoge", aaa.get("bbb"));
	}

	public void testSetPropertyForBean() throws Exception {
		Aaa aaa = new Aaa();
		PropertyUtil.setProperty(aaa, "bbb", "hoge2");
		assertEquals("1", "hoge2", aaa.getBbb());
	}

	protected void setUp() throws Exception {
	}

	protected void tearDown() throws Exception {
	}

	public static Test suite() {
		return new TestSuite(PropertyUtilTest.class);
	}

	public static void main(String[] args) {
		junit.textui.TestRunner.main(
			new String[] { PropertyUtilTest.class.getName()});
	}

	public static class Aaa {
		private String bbb_ = "hoge";

		public String getBbb() {
			return bbb_;
		}
		
		public void setBbb(String bbb) {
			bbb_ = bbb;
		}
	}
}