package org.seasar.struts;

import org.apache.struts.action.Action;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.servlet.S2ContainerServlet;
import org.seasar.framework.util.ClassUtil;

/**
 * @author higa
 *
 */
public final class ActionUtil {

	private ActionUtil() {
	}

	public static Action createAction(String className) {
		S2Container container = S2ContainerServlet.getContainer();
		Class clazz = ClassUtil.forName(className);
		if (container.hasComponentDef(clazz)) {
			return (Action) container.getComponent(clazz);
		} else {
			return (Action) ClassUtil.newInstance(clazz);
		}
	}

}
