package org.seasar.extension.dataset.states;

import javax.sql.DataSource;

import org.seasar.extension.dataset.DataRow;
import org.seasar.extension.dataset.DataTable;
import org.seasar.extension.dataset.RowState;
import org.seasar.extension.dataset.UpdateFailureRuntimeException;
import org.seasar.extension.jdbc.UpdateHandler;
import org.seasar.extension.jdbc.impl.BasicUpdateHandler;

/**
 * @author higa
 *
 */
public abstract class AbstractRowState implements RowState {
	
	AbstractRowState() {
	}
	
	/**
	 * @see org.seasar.extension.dataset.RowState#update(javax.sql.DataSource, org.seasar.extension.dataset.DataRow)
	 */
	public void update(DataSource dataSource, DataRow row)
		throws UpdateFailureRuntimeException {

		String sql = getSql(row.getTable());
		Object[] args = getArgs(row);
		UpdateHandler handler = new BasicUpdateHandler(dataSource, sql);
		execute(handler, args);
	}

	protected abstract String getSql(DataTable table);
	
	protected abstract Object[] getArgs(DataRow row);

	protected void execute(UpdateHandler handler, Object[] args)
		throws UpdateFailureRuntimeException {
			
		int num = handler.execute(args);
		if (num != 1) {
			throw new UpdateFailureRuntimeException();	
		}
	}
}