package org.seasar.extension.jdbc.types;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Types;

import org.seasar.extension.jdbc.ValueType;

/**
 * @author higa
 *
 */
public class NullType implements ValueType {

	/**
	 * @see org.seasar.extension.jdbc.ValueType#getValue(java.sql.ResultSet, int)
	 */
	public Object getValue(ResultSet resultSet, int index)
		throws SQLException {

		return null;
	}

	/**
	 * @see org.seasar.extension.jdbc.ValueType#bindValue(java.sql.PreparedStatement, int, java.lang.Object)
	 */
	public void bindValue(PreparedStatement ps, int index, Object value)
		throws SQLException {

		ps.setNull(index, Types.VARCHAR);
	}

}
