package org.seasar.struts;

import java.io.IOException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.logging.Log;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionServlet;
import org.apache.struts.util.MessageResources;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.factory.SingletonS2ContainerFactory;
import org.seasar.framework.util.ClassUtil;

/**
 * @author higa
 *
 */
public final class ActionUtil {

	private ActionUtil() {
	}

	public static Action createAction(String className) {
		S2Container container = SingletonS2ContainerFactory.getContainer();
		Class clazz = ClassUtil.forName(className);
		if (container.hasComponentDef(clazz)) {
			return (Action) container.getComponent(clazz);
		} else {
			return (Action) ClassUtil.newInstance(clazz);
		}
	}

	public static Action processActionCreate(
		HttpServletRequest request,
		HttpServletResponse response,
		ActionMapping mapping,
		Log log,
		MessageResources internal,
		ActionServlet servlet)
		throws IOException {

		String className = mapping.getType();
		if (log.isDebugEnabled()) {
			log.debug(" Looking for Action instance for class " + className);
		}
		Action instance = null;
		try {
			instance = createAction(className);
		} catch (Exception e) {
			log.error(
				internal.getMessage("actionCreate", mapping.getPath()),
				e);

			response.sendError(
				HttpServletResponse.SC_INTERNAL_SERVER_ERROR,
				internal.getMessage(
					"actionCreate",
					mapping.getPath()));

			return (null);
		}
		instance.setServlet(servlet);
		return (instance);
	}
}
