<?php
/**
 * This code was developped by SECIOSS (http://www.secioss.co.jp/).
 *
 *              Copyright (C) 2009 SECIOSS CORPORATION
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation.
 */
require_once("Log.php");

define('PASSWD', '/etc/httpd/conf/.htpasswd');
define('BASEDIR', '/usr/share/simplesamlphp');

$log = &Log::singleton('syslog', LOG_LOCAL5, 'samcloud');

function authenticate()
{
    global $log;

    if (isset($_POST['user'])) {
        $user = $_POST['user'];
    } else if (isset($_GET['user'])) {
        $user = $_GET['user'];
    } else {
        $user = null;
    }

    if (isset($_POST['password'])) {
        $password = $_POST['password'];
    } else if (isset($_GET['password'])) {
        $password = $_GET['password'];
    } else {
        $password = null;
    }

    if (!$user || !$password) {
        return false;
    }

    $fp = fopen(PASSWD, 'r');
    if ($fp === false) {
        $log->err("Can't open ".PASSWD);

        return false;
    }

    while (!feof($fp)) {
        $buffer = fgets($fp);
        $buffer = rtrim($buffer, "\n");
        list($id, $crypted) = split(":", $buffer);
        if ($user == $id) {
            if ($crypted == crypt($password, substr($crypted, 0, 2))) {
                return true;
            } else {
                return false;
            }
        }
    }

    return false;
}

function setIdpRemote()
{
    global $log;

    $idpconf = BASEDIR.'/metadata/saml20-idp-remote.php';

    foreach (array('idp', 'login', 'logout') as $arg) {
        if (!isset($_POST[$arg])) {
            return array(2, "invalid arguments");
        }
    }

    $idp = $_POST['idp'];
    $login = $_POST['login'];
    $logout = $_POST['logout'];
    $certfingerprint = isset($_POST['certfingerprint']) ? $_POST['certfingerprint'] : null;

    $metadata = file_get_contents($idpconf);
    if ($metadata === false) {
        $log->err("Can't read $idpconf");

        return array(3, "can't read $idpconf");
    }

    $pattern = "
        \/\* Configured by samcloud \*\/
        '$idp' => array\(
                'name' => '[^']+',
                'description' => '[^']+',
                'SingleSignOnService' => '[^']+',
                'SingleLogoutService' => '[^']+',
                'certFingerprint' => '([^']+)'
        \),
";

    if (preg_match("/$pattern/", $metadata)) {
        $certfingerprint = $certfingerprint ? $certfingerprint : '$1';
        $config = "
        /* Configured by samcloud */
        '$idp' => array(
                'name' => '$idp',
                'description' => '$idp',
                'SingleSignOnService' => '$login',
                'SingleLogoutService' => '$logout',
                'certFingerprint' => '$certfingerprint'
        ),
";
        $metadata = preg_replace("/$pattern/", $config, $metadata);
    } else {
        $config = "
        /* Configured by samcloud */
        '$idp' => array(
                'name' => '$idp',
                'description' => '$idp',
                'SingleSignOnService' => '$login',
                'SingleLogoutService' => '$logout',
                'certFingerprint' => '$certfingerprint'
        ),
";
        $metadata = preg_replace('/(\$metadata = array\()/', "$1$config", $metadata);
    }

    if (file_put_contents($idpconf, $metadata) === false) {
        $log->err("Can't write $idpconf");

        return array(3, "Can't write $idpconf");
    }

    return array(0, "Succeed");
}

function writeResponse($result)
{
    $xml = "<response>
  <code>%d</code>
  <message>%s</message>
</response>";

    return sprintf($xml, $result[0], $result[1]);
}

?>
