#!/usr/bin/python
#
# Copyright 2010 SECIOSS Inc.
#

import os
import re
import time
import random
import hashlib
from Cookie import SimpleCookie

from google.appengine.ext import db


class OpenIDSessionDB(db.Expando):
  """An in-progress OpenID login."""
  session_id = db.StringProperty()
  claimed_id = db.StringProperty()
  server_url = db.LinkProperty()
  login_time = db.DateTimeProperty()
  status = db.StringProperty()


class OpenIDSession():
  session = None
  args = None

  def __init__(self):
    self.args = {}

  def load(self, id):
    """Loads the current session.
    """
    if not self.session:
      if id:
        try:
          sessions = OpenIDSessionDB.gql('where session_id = :1', id)
          assert sessions.count()
          self.session = sessions[0]
        except (AssertionError, db.Error), e:
          return None

        fields = self.session.dynamic_properties()
        self.args = dict((f, getattr(self.session, f)) for f in fields)

      else:
        self.args = {}
        self.session = OpenIDSessionDB()
        random.seed()
        random_str = str(random.random()) + str(random.random())
        random_str = random_str + str(time.time())
        random_str = random_str + os.environ['REMOTE_ADDR']
        self.session.session_id = hashlib.sha256(random_str).hexdigest()

      return self.session

  def store(self):
    """Stores the current session.
    """
    assert self.session
    for field, value in self.args.items():
      setattr(self.session, field, value)
    self.session.put()

  def destroy(self):
    """Destroy the current session.
    """
    self.session.delete()
    expires = time.strftime("%a, %d-%b-%Y %H:%M:%S GMT", time.gmtime(0))
    cookie = SimpleCookie(os.environ.get('HTTP_COOKIE', ''))
    cookie['sissession'] = ''
    cookie['sissession']['path'] = '/'
    cookie['sissession']['expires'] = expires
    print cookie.output()

  def getId(self):
    assert self.session
    return self.session.session_id

  def get(self, key):
    assert self.session
    return getattr(self.session, key)

  def set(self, key, value):
    assert self.session
    setattr(self.session, key, value)
    self.session.put()
