<?php
$path = ini_get('include_path');
$path =  dirname(__FILE__) . PATH_SEPARATOR . $path;
ini_set('include_path', $path);

require_once("Log.php");
require_once("Secioss/AutoLogin.php");
require_once("Smarty/Smarty.class.php");

if (strtoupper(substr(PHP_OS, 0, 3)) !== 'WIN') {
    $log = &Log::singleton('syslog', LOG_LOCAL5, $logid);
} else {
    $opts = array('locking' => true, 'timeFormat' => '%Y/%m/%d %H:%M:%S');
    $log = &Log::singleton('file', '/secioss/var/log/auth.log', $logid, $opts);
}

$lang = null;
if (isset($_SESSION['lang']) && $_SESSION['lang']) {
    $lang = $_SESSION['lang'];
} else if (isset($_SERVER['HTTP_ACCEPT_LANGUAGE'])) {
    $accept_lang = ','.$_SERVER['HTTP_ACCEPT_LANGUAGE'].',';
    if (preg_match('/,ja[,;\-]/', $accept_lang)) {
        $lang = 'ja';
    } else if (preg_match('/,en[,;\-]/', $accept_lang)) {
        $lang = 'en';
    }
}
$msgfile = 'message'.($lang ? "_$lang" : '').'.php';
if (!file_exists($msgfile)) {
    $msgfile = 'message.php';
}
require_once($msgfile);

function getTemplateFile($name, $tenant, $lang) {
    $tplfile = $name;
    $tpldir = opendir('./templates');
    $tenant_match = false;
    $lang_match = false;
    while ($file = readdir($tpldir)) {
        if (!preg_match('/^'.$name.'/', $file)) {
            continue;
        }

        if ($tenant && preg_match('/^'.$name.'-'.$tenant.'/', $file)) {
            $tenant_match = true;
        }
        if ($lang && preg_match('/^'.$name.'.*_'.$lang.'/', $file)) {
            $lang_match = true;
        }
        if ($tenant_match && $lang_match) {
            break;
        }
    }
    if ($tenant_match) {
        $tplfile .= "-$tenant";
    }
    if ($lang_match && file_exists($tplfile."_$lang.tpl")) {
        $tplefile .= "_$lang";
    }                
    $tplfile .= '.tpl';
    closedir($tpldir);

    return $tplfile;
}

function sam_auth($url, $username, $password)
{
    $req =& new HTTP_Request("$url?userid=$username&ip=".$_SERVER['REMOTE_ADDR']);
    $req->setMethod(HTTP_REQUEST_METHOD_POST);
    $req->addPostData('password', $password);
    $res = $req->sendRequest();
    if (PEAR::isError($res) || $req->getResponseCode() != 200) {
        return PEAR::raiseError("Authentication server returns error response", -1);
    }

    $xml = simplexml_load_string($req->getResponseBody());
    $rc = intval($xml->code);
    $tokens = null;
    if ($rc < 0) {
        return PEAR::raiseError(strval($xml->message), -1);
    } else if ($rc == 0) {
        $tokens = strval($xml->tokens);
        $ticket = strval($xml->ticket);
    }

    return array($rc, $tokens, $ticket);
}

function logformat($message)
{
    $ipaddr = isset($_SERVER['REMOTE_ADDR']) ? $_SERVER['REMOTE_ADDR'] : '-';
    if (isset($_SERVER['REMOTE_USER'])) {
        $user = $_SERVER['REMOTE_USER'];
    } else if (isset($_SESSION['username'])) {
        $user = $_SESSION['username'];
    } else {
        $user = '-';
    }
    $tenant = preg_match('/@(.+)$/', $user, $matches) ? $matches[1] : '-';

    return "$ipaddr; $tenant; $user; $message";
}

?>
