#!/bin/sh

PRODUCT="Secioss Identity Suite Cloud Edition SP"
PREFIX="/opt/secioss"
CONF="$PREFIX/etc/openldap/slapd.conf"
LOG="/tmp/install.log"

function install() {
    rpm -q libtool-ltdl > $LOG 2>&1
    if [ $? -ne 0 ]; then
        echo "libtool-ltdlをインストールしてください。"
        return 1
    fi

    rpm -q perl-LDAP >> $LOG 2>&1
    if [ $? -ne 0 ]; then
        echo "perl-LDAPをインストールしてください。"
        return 1
    fi

    rpm -q perl-DBI >> $LOG 2>&1
    if [ $? -ne 0 ]; then
        echo "perl-DBIをインストールしてください。"
        return 1
    fi

    rpm -q perl-DBD-Pg >> $LOG 2>&1
    if [ $? -ne 0 ]; then
        echo "perl-DBD-Pgをインストールしてください。"
        return 1
    fi

    rpm -q perl-Digest-SHA1 >> $LOG 2>&1
    if [ $? -ne 0 ]; then
        echo "perl-Digest-SHA1をインストールしてください。"
        return 1
    fi

    rpm -q perl-XML-LibXML >> $LOG 2>&1
    if [ $? -ne 0 ]; then
        echo "perl-XML-LibXMLをインストールしてください。"
        return 1
    fi

    rpm -q perl-XML-Simple >> $LOG 2>&1
    if [ $? -ne 0 ]; then
        echo "perl-XML-Simpleをインストールしてください。"
        return 1
    fi

    rpm -q perl-TimeDate >> $LOG 2>&1
    if [ $? -ne 0 ]; then
        echo "perl-TimeDateをインストールしてください。"
        return 1
    fi

    rpm -q php-pear >> $LOG 2>&1
    if [ $? -ne 0 ]; then
        echo "php-pearをインストールしてください。"
        return 1
    fi

    rpm -q php-xml >> $LOG 2>&1
    if [ $? -ne 0 ]; then
        echo "php-xmlをインストールしてください。"
        return 1
    fi

    rpm -q php-soap >> $LOG 2>&1
    if [ $? -ne 0 ]; then
        echo "php-soapをインストールしてください。"
        return 1
    fi

    rpm -Uvh ./third_party/perl-version-* >> $LOG 2>&1
    rpm -Uvh ./third_party/perl-MailTools-* >> $LOG 2>&1
    rpm -Uvh ./third_party/php-pear-Net-Socket-* >> $LOG 2>&1
    rpm -Uvh ./third_party/php-pear-Net-URL-* >> $LOG 2>&1
    rpm -Uvh ./third_party/php-pear-MDB2-* >> $LOG 2>&1
    for f in `ls ./third_party`; do
        rpm -q `echo $f | sed s/-[0-9].*//` > /dev/null
        if [ $? -ne 0 ]; then
            rpm -Uvh ./third_party/$f >> $LOG 2>&1
        fi
    done
    echo "$PRODUCTに必要なパッケージをインストールしました。"

    rpm -Uvh ./software/perl-Net-LDAP-Server-*-[0-9]*.secioss.noarch.rpm >> $LOG 2>&1
    if [ $? -ne 0 ]; then
        echo "perl-Net-LDAP-Serverのインストールに失敗しました。"
        return 1
    fi
    echo "perl-Net-LDAP-Serverをインストールしました。"

    rpm -Uvh ./software/perl-VUser-Google-ProvisioningAPI-*-[0-9]*.secioss.noarch.rpm >> $LOG 2>&1
    if [ $? -ne 0 ]; then
        echo "perl-VUser-Google-ProvisioningAPIのインストールに失敗しました。"
        rpm -e perl-Net-LDAP-Server
        return 1
    fi
    echo "perl-VUser-Google-ProvisioningAPIをインストールしました。"

    rpm -Uvh ./software/openldap23-2.3.[0-9]*-[0-9]*.secioss.*.rpm \
             ./software/openldap23-servers-2.3.[0-9]*-[0-9]*.secioss.*.rpm >> $LOG 2>&1
    if [ $? -ne 0 ]; then
        echo "openldapのインストールに失敗しました。"
        rpm -e perl-Net-LDAP-Server perl-VUser-Google-ProvisioningAPI
        return 1
    fi
    echo "openldapをインストールしました。"

    rpm -Uvh ./software/perl-LISM-[0-9]*.[0-9]*.[0-9]*-[0-9]*.secioss.noarch.rpm >> $LOG 2>&1
    if [ $? -ne 0 ]; then
        echo "LISMのインストールに失敗しました。"
        rpm -e perl-Net-LDAP-Server perl-VUser-Google-ProvisioningAPI openldap23 openldap23-servers
        return 1
    fi
    echo "LISMをインストールしました。"

    rpm -q php-Secioss-AutoLogin >& /dev/null
    if [ $? -ne 0 ]; then
        rpm -Uvh ./software/php-Secioss-AutoLogin-*.secioss.noarch.rpm >> $LOG 2>&1
        if [ $? -ne 0 ]; then
            echo "php-Secioss-AutoLoginのインストールに失敗しました。"
            rpm -e perl-Net-LDAP-Server perl-VUser-Google-ProvisioningAPI openldap23 openldap23-servers perl-LISM
            return 1
        fi
        echo "php-Secioss-AutoLoginをインストールしました。"
    fi

    rpm -q access-manager-apps >& /dev/null
    if [ $? -ne 0 ]; then
        rpm -Uvh ./software/access-manager-apps-*.secioss.noarch.rpm >> $LOG 2>&1
        if [ $? -ne 0 ]; then
            echo "access-manager-appsのインストールに失敗しました。"
            rpm -e perl-Net-LDAP-Server perl-VUser-Google-ProvisioningAPI openldap23 openldap23-servers perl-LISM php-Secioss-AutoLogin
            return 1
        fi
        echo "access-manager-appsをインストールしました。"
    fi

    rpm -Uvh ./software/simplesamlphp-*.rpm >> $LOG 2>&1
    if [ $? -ne 0 ]; then
        echo "simplesamlphpのインストールに失敗しました。"
        rpm -e perl-Net-LDAP-Server perl-VUser-Google-ProvisioningAPI openldap23 openldap23-servers perl-LISM php-Secioss-AutoLogin access-manager-apps
        return 1
    fi

    cp ./src/{SoapLism.pm,lism.cgi,lismapi.conf} /var/www/cgi-bin/
    cp ./src/saml_sp.php /var/www/lib/
    cp ./src/idsync /opt/secioss/sbin/
    cp ./conf/config.ini /var/www/conf/
    cp ./conf/config.php /usr/share/simplesamlphp/config/
    cp ./conf/saml20* /usr/share/simplesamlphp/metadata/
    chown ldap.apache /opt/secioss/etc/lism.conf
    cp ./conf/{lism.conf,lism-sp.conf,sugarcrm-userpref.txt} /opt/secioss/etc/
    chown ldap.apache /opt/secioss/etc/{lism.conf,lism-sp.conf,sugarcrm-userpref.txt}
    chown apache /opt/secioss/var/lib/ldap
    chmod 770 /opt/secioss/var/lib/ldap
    if [ ! -d /opt/secioss/var/lib/csv ]; then
        mkdir /opt/secioss/var/lib/csv
    fi
    chown apache.ldap /opt/secioss/var/lib/csv
    chmod 770 /opt/secioss/var/lib/csv
    cp ./conf/autologin.conf /etc/httpd/conf.d/

    echo "$PRODUCTのインストールが完了しました。"
}

function update() {
    rpm -Fvh ./third_party/* > $LOG 2>&1
    echo "$PRODUCTに必要なパッケージをアップデートしました。"

    rpm -Fvh ./software/perl-Net-LDAP-Server-*-[0-9]*.secioss.noarch.rpm >> $LOG 2>&1
    if [ $? -ne 0 ]; then
        echo "perl-Net-LDAP-Serverのアップデートに失敗しました。"
        return 1
    fi
    echo "perl-Net-LDAP-Serverをアップデートしました。"

    rpm -Fvh ./software/perl-VUser-Google-ProvisioningAPI-*-[0-9]*.secioss.noarch.rpm >> $LOG 2>&1
    if [ $? -ne 0 ]; then
        echo "perl-VUser-Google-ProvisioningAPIのアップデートに失敗しました。"
        return 1
    fi
    echo "perl-VUser-Google-ProvisioningAPIをアップデートしました。"

    rpm -Fvh ./software/openldap23-2.3.[0-9]*-[0-9]*.secioss.*.rpm \
             ./software/openldap23-servers-2.3.[0-9]*-[0-9]*.secioss.*.rpm >> $LOG 2>&1
    if [ $? -ne 0 ]; then
        echo "openldapのアップデートに失敗しました。"
        return 1
    fi
    echo "openldapをアップデートしました。"

    rpm -Fvh ./software/perl-LISM-[0-9]*.[0-9]*.[0-9]*-[0-9]*.secioss.noarch.rpm >> $LOG 2>&1
    if [ $? -ne 0 ]; then
        echo "LISMのアップデートに失敗しました。"
        return 1
    fi
    echo "LISMをアップデートしました。"

    rpm -Fvh ./software/php-Secioss-AutoLogin-*.secioss.noarch.rpm >> $LOG 2>&1
    if [ $? -ne 0 ]; then
        echo "php-Secioss-AutoLoginのアップデートに失敗しました。"
        return 1
    fi
    echo "php-Secioss-AutoLoginをアップデートしました。"

    rpm -Fvh ./software/access-manager-apps-*.secioss.noarch.rpm >> $LOG 2>&1
    if [ $? -ne 0 ]; then
        echo "access-manager-appsのアップデートに失敗しました。"
        return 1
    fi
    echo "access-manager-appsをアップデートしました。"

    rpm -Fvh ./software/simplesamlphp-*.rpm >> $LOG 2>&1
    if [ $? -ne 0 ]; then
        echo "simplesamlphpのアップデートに失敗しました。"
        return 1
    fi

    cp ./src/saml_sp.php /var/www/lib/
    cp ./src/{SoapLism.pm,lism.cgi}  /var/www/cgi-bin/
    cp ./src/idsync /opt/secioss/sbin/

    echo "$PRODUCTのアップデートが完了しました。"
}

function uninstall() {
    rm /var/www/cgi-bin/{SoapLism.pm,lism.cgi,lismapi.conf}
    rm /var/www/lib/saml_sp.php
    rm /opt/secioss/sbin/idsync

    rpm -e simplesamlphp >> $LOG 2>&1
    if [ $? -ne 0 ]; then
        echo "simplesamlphpのアンインストールに失敗しました。"
    else
        echo "simplesamlphpをアンインストールしました。"
    fi

    rpm -e access-manager-apps > $LOG 2>&1
    if [ $? -ne 0 ]; then
        echo "access-manager-appsのアンインストールに失敗しました。"
    else
        echo "access-manager-appsをアンインストールしました。"
    fi

    rpm -e php-Secioss-AutoLogin >> $LOG 2>&1
    if [ $? -ne 0 ]; then
        echo "php-Secioss-AutoLoginのアンインストールに失敗しました。"
    else
        echo "php-Secioss-AutoLoginをアンインストールしました。"
    fi

    rpm -e perl-LISM >> $LOG 2>&1
    if [ $? -ne 0 ]; then
        echo "LISMのアンインストールに失敗しました。"
    else
        echo "LISMをアンインストールしました。"
    fi

    rpm -e openldap23 openldap23-servers >> $LOG 2>&1
    if [ $? -ne 0 ]; then
        echo "openldapのアンインストールに失敗しました。"
    else
        echo "openldapをアンインストールしました。"
    fi

    rpm -e perl-VUser-Google-ProvisioningAPI >> $LOG 2>&1
    if [ $? -ne 0 ]; then
        echo "perl-VUser-Google-ProvisioningAPIのアンインストールに失敗しました。"
    else
        echo "perl-VUser-Google-ProvisioningAPIをアンインストールしました。"
    fi

    rpm -e perl-Net-LDAP-Server >> $LOG 2>&1
    if [ $? -ne 0 ]; then
        echo "perl-Net-LDAP-Serverのアンインストールに失敗しました。"
    else
        echo "perl-Net-LDAP-Serverをアンインストールしました。"
    fi

    rm -f /etc/httpd/conf.d/autologin.conf

    echo "$PRODUCTのアンインストールが完了しました。"
}

case "$1" in
    install)
        install
        ;;
    update)
        update
        ;;
    uninstall)
        uninstall
        ;;
    *)
        echo $"Usage: $0 {install|update|uninstall}"
esac

