<?php
$logid = 'Certificate';

require_once("../lib/util.php");

if (isset($_SESSION['lang']) && $_SESSION['lang']) {
    $lang = $_SESSION['lang'];
}

$error = 0;
$message = '';
$app = null;

$conf = parse_ini_file("../conf/config.ini", true);
if (empty($conf)) {
     $log->crit(logformat("Can't read config.ini"));
     exit(1);
}

if (!isset($conf['password'])) {
     $log->crit(logformat("Set password configuration"));
     exit(1);
}

$user = isset($_SERVER['REMOTE_USER']) ? $_SERVER['REMOTE_USER'] : null;
$tenant = '';
if (preg_match('/^[^@]+@(.*)$/', $user, $matches)) {
    $tenant = $matches[1];
    $tenant = preg_replace('/([*()])/', '\\$1', $tenant);
}

if ($tenant && file_exists('./templates/certificate-'.$tenant.'.tpl')) {
    $tplfile = 'certificate-'.$tenant.'.tpl';
} else {
    $tplfile = 'certificate.tpl';
}

$login = new AutoLogin($conf['password']['storage'], $conf['password']);

$rc = $login->setUser($user, true);
if (PEAR::isError($rc)) {
    $log->crit(logformat("Setting certificate failed: ". $rc->getMessage()));
    $error = 1;
    $message = USS_ERR_003;
} else if (isset($_FILES['certificate'])) {
    $certificate = '';
    if (!$_FILES['certificate']['name']) {
        $log->err(logformat("Certificate is invalid"));
        $message = USS_ERR_201;
        $error = 1;
    } else {
        $begin_cert = false;
        $file = fopen($_FILES['certificate']['tmp_name'], 'r');
        while (!feof($file)) {
            $line = chop(fgets($file));
            if ($line == '-----BEGIN CERTIFICATE-----') {
                $begin_cert = true;
            } else if ($line == '-----END CERTIFICATE-----') {
                break;
            } else if ($begin_cert) {
                $certificate .= $line;
            }
        }
        fclose($file);
    }

    if ($certificate) {
        $certificateattr = 'usercertificate;binary';
        if ($conf['password']['certificateattr']) {
            $certificateattr = 'seciosscertificate';
        }
        $rc = $login->set($certificateattr, $certificate);
        if (PEAR::isError($rc)) {
            $error = 1;
            switch($rc->getCode()) {
              case AUTO_LOGIN_INVALID_VALUE:
                $log->err(logformat("Certificate is invalid"));
                $message = USS_ERR_201;
                break;
              default:
                $log->crit(logformat("Setting certificate failed: ". $rc->getMessage()));
                $message = USS_ERR_202;
            }
        } else {
            if ($rc) {
                $log->notice(logformat("Setting certificate suceeded"));
                $message = USS_NML_201;
            }
        }
    }
} else {
    if (isset($_GET['msg'])) {
        $message = constant($_GET['msg']);
    }
}

$smarty = new Smarty();
$smarty->template_dir = 'templates';
$smarty->compile_dir = 'templates_c';

$smarty->assign('username', $user);
$smarty->assign('error', $error);
$smarty->assign('message', $message);
$smarty->assign('uri', $_SERVER['SCRIPT_NAME'].'?app=certificate');
if ($use_menu) {
    $smarty->assign('use_menu', 1);
}

$smarty->display($tplfile);
?>
