#!/bin/sh

app=$1

if [ "$app" = "sso" ]; then
    idpurl=
    while [ -z "$idpurl" ]; do
        if [ $LANG = ja_JP.UTF-8 ]; then
            printf "認証サービスのURL [https://slink.secioss.com]: "
        else
            printf "URL of authentication service [https://slink.secioss.com]: "
        fi
        read idpurl leftover
        if [ -z "$idpurl" ]; then
            idpurl="https://slink.secioss.com"
        fi
    done

    tenant=
    while [ -z "$tenant" ]; do
        if [ $LANG = ja_JP.UTF-8 ]; then
            printf "テナントID: "
        else
            printf "Tenant ID: "
        fi
        read tenant leftover
    done

    url=
    while [ -z "$url" ]; do
        if [ $LANG = ja_JP.UTF-8 ]; then
            printf "アプリケーションのURL: "
        else
            printf "URL of application: "
        fi
        read url leftover
    done

    session=
    while [ -z "$session" ]; do
        if [ $LANG = ja_JP.UTF-8 ]; then
            printf "セッションのクッキー名: "
        else
            printf "Cookie name of session: "
        fi
        read session leftover
    done

    entityid=`echo $url | sed 's#[^/]*$##'`
    rurl=`echo $url | sed 's#/[^/]*$##'`
    path=`echo $rurl | sed 's#^https*://[^/]*/##'`

    if [ -z $path ]; then
        echo "Invalid url"
        exit 1
    fi

    appname=`echo $path | sed 's#^\([^/]*\)/*.*$#\1#'`

    sed s#\'path#\'$path# ./conf/config.php | sed s#https://slink.secioss.com#$idpurl/$tenant# | sed s/SESSIONNAME/$session/ > /tmp/config.php
    mv /tmp/config.php /usr/share/simplesamlphp/config/config.php

    sed s#https://slink.secioss.com/saml/#$idpurl/saml/# ./conf/saml20-idp-remote.php | sed s#\'https://slink.secioss.com\'#\'$idpurl/$tenant\'# > /tmp/saml20-idp-remote.php
    mv /tmp/saml20-idp-remote.php /usr/share/simplesamlphp/metadata/saml20-idp-remote.php

    sed s#https://sp.example.com/path#$entityid# ./conf/saml20-sp-hosted.php > /tmp/saml20-sp-hosted.php
    mv /tmp/saml20-sp-hosted.php /usr/share/simplesamlphp/metadata/saml20-sp-hosted.php

    sed "s#[^ ]*/saml#/$path/saml#" /etc/httpd/conf.d/simplesamlphp.conf > /tmp/simplesamlphp.conf
    mv /tmp/simplesamlphp.conf /etc/httpd/conf.d/simplesamlphp.conf

    sed s#path#$path# ./conf/autologin.conf > /tmp/autologin.conf
    mv /tmp/autologin.conf /etc/httpd/conf.d/autologin.conf

    if [ ! -f /usr/share/simplesamlphp/cert/PublicKey-idp.pem ]; then
        wget -P /usr/share/simplesamlphp/cert/ $idpurl/public/PublicKey-idp.pem >& /dev/null
    fi

    sed "s#^loginurl = .*#loginurl = $rurl/sso/autologin.php?sso_app=$appname#" /var/www/conf/oauth.conf | sed "s/^sessionname = .*$/sessionname = $session/" > /tmp/oauth.conf
    mv /tmp/oauth.conf /var/www/conf/oauth.conf

    sed s#path#$path# ./conf/oauth.conf > /tmp/oauth.conf
    mv /tmp/oauth.conf /etc/httpd/conf.d/oauth.conf
elif [ "$app" = "idm" ]; then
    idmurl=
    while [ -z "$idmurl" ]; do
        if [ $LANG = ja_JP.UTF-8 ]; then
            printf "統合ID管理サービスのURL [https://slink.secioss.com]: "
        else
            printf "URL of authentication service [https://slink.secioss.com]: "
        fi
        read idmurl leftover
        if [ -z "$idmurl" ]; then
            idmurl="https://slink.secioss.com"
        fi
    done

    tenant=
    while [ -z "$tenant" ]; do
        if [ $LANG = ja_JP.UTF-8 ]; then
            printf "テナントID: "
        else
            printf "Tenant ID: "
        fi
        read tenant leftover
    done

    admin=
    while [ -z "$admin" ]; do
        if [ $LANG = ja_JP.UTF-8 ]; then
            printf "管理者アカウント名: "
        else
            printf "Account name of administrator: "
        fi
        read admin leftover
    done

    password=
    while [ -z "$password" ]; do
        if [ $LANG = ja_JP.UTF-8 ]; then
            printf "管理者のパスワード: "
        else
            printf "Password of administrator: "
        fi
        read password leftover
    done

    type=0
    while [ $type -lt 1 -o $type -gt 2 ]; do
        if [ $LANG = ja_JP.UTF-8 ]; then
            printf "同期の向き [1.統合ID管理 -> サービス|2.サービス -> 統合ID管理]: "
        else
            printf "Direction of synchronization [1.Identity Management -> Service|2.Service -> Identity Management]: "
        fi
        read type leftover
    done

    attrnum=0
    if [ $type -eq 1 ]; then
        service=
        while [ -z "$service" ]; do
            if [ $LANG = ja_JP.UTF-8 ]; then
                printf "サービスID: "
            else
                printf "Service ID: "
            fi
            read service leftover
        done

        while [ $attrnum -lt 1 -o $attrnum -gt 5 ]; do
            if [ $LANG = ja_JP.UTF-8 ]; then
                printf "ユーザIDの属性 [1.ユーザID|2.ユーザID@テナントID|3.メールアドレス|4.社員番号|5.サービス個別のログインID]: "
            else
                printf "Attribute of user id [1.user id|2.user id@tenant id|3.mail address|4.employee number|5.login id of service]: "
            fi
            read attrnum leftover
        done
    fi

    if [ $type -eq 1 ]; then
        sed s/TENANTID/$tenant/g ./conf/lism-sp.conf | sed s/ADMINID/$admin/ | sed s/ADMINPW/$password/ | sed s/SERVICEID/$service/ | sed s#https://slink.secioss.com#$idmurl# > /tmp/lism-sp.conf
        if [ $attrnum -eq 1 ]; then
            sed "s/ *<!-- id//" /tmp/lism-sp.conf | sed "s/ *id -->//" > /tmp/lism-sp2.conf
            mv /tmp/lism-sp2.conf /tmp/lism-sp.conf
        elif [ $attrnum -ge 3 ]; then
            if [ $attrnum -eq 3 ]; then
                attribute=mail
            elif [ $attrnum -eq 4 ]; then
                attribute=employeeNumber
            elif [ $attrnum -eq 5 ]; then
                attribute="seciossLoginId;x-sys-$service@$tenant"
            fi
            sed "s/ *<!-- attribute//" /tmp/lism-sp.conf | sed "s/ *attribute -->//" | sed s/ATTRIBUTE/$attribute/ > /tmp/lism-sp2.conf
            mv /tmp/lism-sp2.conf /tmp/lism-sp.conf
        fi
        mv /tmp/lism-sp.conf /opt/secioss/etc/lism-sp.conf
        sed "s/seciossAllowedService=[^)]*/seciossAllowedService=$service-$tenant/" /opt/secioss/etc/lism.conf | sed "s/<constant>.*<\/constant>/<constant>$service-$tenant<\/constant>/" > /tmp/lism.conf
        mv /tmp/lism.conf /opt/secioss/etc/lism.conf

        sed s#/opt/secioss/etc/[^\']*#/opt/secioss/etc/lism.conf# /var/www/html/lism/config.php > /tmp/config.php
        mv /tmp/config.php /var/www/html/lism/config.php
    else
        sed s/uid%1%2@[^\"]*/uid%1%2@$tenant/ /opt/secioss/etc/lism-idp.conf | sed "s/<basedn>o=[^,]*/<basedn>o=$tenant/" | sed "s/<binddn>uid=[^,]*,ou=People,o=[^,]*/<binddn>$admin@$tenant,ou=People,o=$tenant/" | sed "s/<bindpw>[^<]*/<bindpw>$password/" | sed "s/!(uid=[^)]*/!(uid=$admin/" | sed s#https://slink.secioss.com#$idmurl# > /tmp/lism-idp.conf
        mv /tmp/lism-idp.conf /opt/secioss/etc/lism-idp.conf

        sed s#/opt/secioss/etc/[^\']*#/opt/secioss/etc/lism-idp.conf# /var/www/html/lism/config.php > /tmp/config.php
        mv /tmp/config.php /var/www/html/lism/config.php
    fi

    sed s/ADMINID/$admin/ ./src/lismapi.conf | sed s/ADMINPW/$password/ > /tmp/lismapi.conf
    mv /tmp/lismapi.conf /var/www/cgi-bin/lism/lismapi.conf
elif [ "$app" == "oauth" ]; then
    type=0
    while [ $type -lt 1 -o $type -gt 2 ]; do
        if [ $LANG = ja_JP.UTF-8 ]; then
            printf "データベースの種類 [1.mysql|2.PostgreSQL]: "
        else
            printf "Database type: "
        fi
        read type leftover
    done

    host=
    while [ -z "$host" ]; do
        if [ $LANG = ja_JP.UTF-8 ]; then
            printf "データベースのホスト名: "
        else
            printf "Database host name: "
        fi
        read host leftover
    done

    dbuser=
    while [ -z "$dbuser" ]; do
        if [ $LANG = ja_JP.UTF-8 ]; then
            printf "データベースのユーザ: "
        else
            printf "Database user: "
        fi
        read dbuser leftover
    done

    dbpasswd=
    while [ -z "$dbpasswd" ]; do
        if [ $LANG = ja_JP.UTF-8 ]; then
            printf "データベースのパスワード: "
        else
            printf "Database password: "
        fi
        read dbpasswd leftover
    done

    if [ $type -eq 1 ]; then
        phpdsn="mysql:host=$host;dbname=oauth2"
        perldsn="DBI:mysql:oauth2:$host"
    elif [ $type -eq 2 ]; then
        phpdsn="pgsql:host=$host;dbname=oauth2"
        perldsn="DBI:Pg:dbname=oauth2;host=$host"
    fi

    sed "s/^dsn = .*$/dsn = \"$phpdsn\"/" /var/www/conf/oauth.conf | sed "s/^dbuser = .*$/dbuser = $dbuser/" | sed "s/^dbpasswd = .*$/dbpasswd = $dbpasswd/" > /tmp/oauth.conf
    mv /tmp/oauth.conf /var/www/conf/oauth.conf

    sed "s/^oauth_dsn .*$/oauth_dsn $perldsn/" /var/www/cgi-bin/lism/lism_restapi.conf | sed "s/^oauth_dbuser .*$/oauth_dbuser $dbuser/" | sed "s/^oauth_dbpasswd .*$/oauth_dbpasswd $dbpasswd/" > /tmp/lism_restapi.conf
    mv /tmp/lism_restapi.conf /var/www/cgi-bin/lism/lism_restapi.conf
else
    echo "usage: config.sh sso|idm"
fi
