<?php
$logid = 'MobileID';

require_once("../lib/util.php");

if (strtoupper(substr(PHP_OS, 0, 3)) !== 'WIN') {
    $log = &Log::singleton('syslog', LOG_LOCAL5, $logid);
} else {
    $opts = array('locking' => true, 'timeFormat' => '%Y/%m/%d %H:%M:%S');
    $log = &Log::singleton('file', '/secioss/var/log/auth.log', $logid, $opts);
}

if (isset($_SESSION['lang']) && $_SESSION['lang']) {
    $lang = $_SESSION['lang'];
}

$success = false;
$error = 0;
$message = '';
$app = null;

$conf = parse_ini_file("../conf/config.ini", true);
if (empty($conf)) {
     $log->crit(logformat("Can't read config.ini"));
     exit(1);
}

if (!isset($conf['password'])) {
     $log->crit(logformat("Set password configuration"));
     exit(1);
}

$user = isset($_SERVER['REMOTE_USER']) ? $_SERVER['REMOTE_USER'] : null;
$tenant = '';
if (preg_match('/^[^@]+@(.*)$/', $user, $matches)) {
    $tenant = $matches[1];
    $tenant = preg_replace('/([*()])/', '\\$1', $tenant);
}

if ($tenant && file_exists('./templates/mobileid-'.$tenant.'.tpl')) {
    $tplfile = 'mobileid-'.$tenant.'.tpl';
} else {
    $tplfile = 'mobileid.tpl';
}

$login = new AutoLogin($conf['password']['storage'], $conf['password']);

$rc = $login->setUser($user, true);
if (PEAR::isError($rc)) {
    $log->crit(logformat("Setting mobile id failed: ". $rc->getMessage()));
    $error = 1;
    $message = USS_ERR_003;
}

$mobileid = null;
$agent = $_SERVER['HTTP_USER_AGENT'];
if (preg_match('/DoCoMo|UP\.Browser\/|J-PHONE|Vodafone|Softbank/', $agent)) {
    if (preg_match('/DoCoMo/', $agent)) {
        if (preg_match('/ser([0-9a-zA-Z]+)/', $agent, $matches)) {
            $mobileid = $matches[1];
        }
        if (preg_match('/icc([0-9a-zA-Z]+)/', $agent, $matches)) {
            $mobileid = $mobileid.'#'.$matches[1];
        }
    } else if (preg_match('/UP\.Browser\//', $agent)) {
        $mobileid = isset($_SERVER['HTTP_X_UP_SUBNO']) ? $_SERVER['HTTP_X_UP_SUBNO'] : null;
    } else if (preg_match('/J-PHONE|Vodafone|Softbank/', $agent)) {
        if (preg_match('/SN([0-9a-zA-Z]+)/', $agent)) {
            $mobileid = $matches[1];
        }
    }
}

if ($mobileid) {
    $rc = $login->set('seciossmobileid', $mobileid);
    if (PEAR::isError($rc)) {
        $error = 1;
        switch($rc->getCode()) {
          case AUTO_LOGIN_INVALID_VALUE:
            $log->err(logformat("Moble id is invalid"));
            $message = USS_ERR_101;
            break;
          default:
            $log->crit(logformat("Setting mobile id failed: ". $rc->getMessage()));
            $message = USS_ERR_102;
        }
    } else {
        if ($rc) {
            $log->notice(logformat("Setting mobile id suceeded"));
            $message = USS_NML_101;
            $success = true;
        }
    }
} else {
    if (isset($_GET['msg'])) {
        $message = constant($_GET['msg']);
    }
}

$smarty = new Smarty();
$smarty->template_dir = 'templates';
$smarty->compile_dir = 'templates_c';

$smarty->assign('username', $user);
$smarty->assign('error', $error);
$smarty->assign('message', $message);
$smarty->assign('uri', $_SERVER['SCRIPT_NAME'].'?app=mobileid');
if ($success) {
    $smarty->assign('success', true);
}
if (isset($conf['password']['usepassword']) && $conf['password']['usepassword']) {
    $smarty->assign('usepassword', 1);
}

$smarty->display($tplfile);
?>
