<?php
require_once('DB.php');
require_once('config.php');
header("Cache-Control: no-cache, must-revalidate"); // HTTP/1.1
header("Expires: Sat, 26 Jul 1997 05:00:00 GMT"); // Date in the past
if (file_exists(LISM))
{
    $lismxml = simplexml_load_file(LISM); 
}
else 
{
    echo('ファイルが開けません。: '. LISM);
    exit(1);
}
$system = $_GET['system'];
$getfield = empty($_GET['getfield']) ? '0' : $_GET['getfield'];
$dbinfo = array();
foreach ($lismxml->data as $v)
{
    $system_elt = (string)$v->attributes()->name;
    if ($system_elt == $system)
    {
        $dbserver = '';
        $host = '';
        $database = '';
        $dsn = (string)$v->storage->dsn;
        if ($dsn && preg_match('/^DBI:([^:]+):/', $dsn, $matches)) {
            $dbserver = $matches[1];
            switch ($dbserver) {
              case 'mysql':
                if (preg_match("/^DBI:mysql:([^:]+):(.+)/", $dsn, $matches)) {
                    $database = $matches[1];
                    $host = $matches[2];
                }
                break;
              case 'Pg':
                $dbserver = 'pgsql';
                if (preg_match("/^DBI:Pg:dbname=([^;]+);host=(.+)/", $dsn, $matches)) {
                    $database = $matches[1];
                    $host = $matches[2];
                }
                break;
              case 'Oracle':
                $dbserver = 'oci8';
                if (preg_match("/^DBI:Oracle:host=([^;]+);sid=(.+)/", $dsn, $matches)) {
                    $database = $matches[2];
                    $host = $matches[1];
                }
                break;
              default:
            }
        }
        $admin = (string)$v->storage->admin;
        $passwd = (string)$v->storage->passwd;
        $pwhash = (string)$v->storage->attributes()->hash;
        $charcode = (string)$v->storage->mbcode;

        //table
        foreach ($v->storage->object as $vv)
        {
            if ((string)$vv->attributes()->name == 'User')
            {
                $table = (string)$vv->table;
            }
        }

        $dbinfo = array_merge($dbinfo, array(compact('dbserver', 'host', 'database', 'admin', 'passwd', 'pwhash', 'table', 'charcode')));

        break;
    }
}

////////////////////////////////////////////////////
////////////////response ///////////////////////////
switch ($getfield)
{
    case "1": 
        //get fields only
        echo json_encode(getColumns($dbserver, $host, $admin, $passwd, $database, $table));
        break;
    case "2":
        //get checked fields only
        $checked = array();
        foreach ($lismxml->sync->data as $v)
        {
            $system_elt = (string)$v->attributes()->name;
            if ($system_elt == $system || $system_elt == 'IDP')
            {
                foreach ($v->object->syncattr as $vv)
                {
                    $checked[] = array("master" => (string)$vv->name);
                }
            }
        }
        echo json_encode($checked);
        break;
    case "0":
    default :
        //get db info only
        echo json_encode($dbinfo);
        break;
}

///////////////////////////////////////////////////////////////////
//////////////ライブラリ　カスタマいすしてください/////////////////
//TODO: ＤＢへ接続して、テーブルからフィールドを取得する。
function getColumns($dbserver, $host, $admin, $passwd, $database, $table)
{
    $cols = array();

    if (!$host || !$admin || !$passwd) {
        return $cols;
    }

    $dsn = "$dbserver://$admin:$passwd@$host/$database";
    $db =& DB::connect($dsn, true);
    if (PEAR::isError($db)) {
        echo('DBに接続できません。: ' . $db->getMessage());
        exit(1);
    }

    $sql = '';
    $fieldname = '';
    switch($dbserver) {
      case 'mysql':
        $sql = "SHOW COLUMNS FROM {$table}";
        $fieldname = 'Field';
        break;
      case 'pgsql':
        $sql = "SELECT attname FROM pg_attribute WHERE attrelid = '{$table}'::regclass AND attnum > 0";
        $fieldname = 'attname';
        break;
      case 'oci8':
        $sql = "SELECT COLUMN_NAME FROM USER_TAB_COLUMNS WHERE TABLE_NAME = '{$table}'";
        $fieldname = 'COLUMN_NAME';
        break;
      default:
    }
    $result =& $db->query($sql);
    if (PEAR::isError($result)) {
        echo('DBの検索に失敗しました。: ' . $result->getMessage());
        exit(1);
    }
    if ($result->numRows() > 0) {
        while($row = $result->fetchRow(DB_FETCHMODE_ASSOC)) {
            if (preg_match('/^[0-9a-zA-Z_]/', $row[$fieldname])) {
                $cols[] = array('field' => $row[$fieldname]);
            }
        }
    }

    return $cols;
}
?>
