<?php
    require_once('../www/_include.php');

    define('SSOCONF', '/etc/httpd/conf/sso.conf');

    $session = SimpleSAML_Session::getInstance();
    list($username) = $session->getAttribute('seciossloginid');
    $tenant = $session->getAttribute('tenant');
    $tenant = is_array($tenant) ? $tenant[0] : $tenant;
    $spentityid = isset($_GET['spentityid']) ? $_GET['spentityid'] : '-';

    $agent = 'computer';
    if (preg_match('/DoCoMo|UP\.Browser\/|J-PHONE|Vodafone|SoftBank/', $_SERVER['HTTP_USER_AGENT'])) {
        $agent = 'mobile';
    } else if (preg_match('/(iPhone|Android)/', $_SERVER['HTTP_USER_AGENT'])) {
        $agent = 'smartphone';
    } else if (preg_match('/iPad/', $_SERVER['HTTP_USER_AGENT'])) {
        $agent = 'tablet';
    }
    SimpleSAML_Logger::notice("$tenant; $username; $agent; SAML login to $spentityid failed: forbidden");

    $url = '/error/HTTP_FORBIDDEN.html.var';
    if (file_exists(SSOCONF)) {
        $config = file_get_contents(SSOCONF);
        if (preg_match("/\n[^#]*TKTAuthUnauthURL +(.+)/", $config, $matches)) {
            $url = $matches[1];
        }
    }

    header('Location: '.$url);
    exit(0);
?>
