<?php
$session_name_new = "sidsuite_idp";
$session_name_org = session_name($session_name_new);

session_start();
$_SESSION['lang'] = 'en';
require_once("../lib/util.php");


$logid = 'user';
if (strtoupper(substr(PHP_OS, 0, 3)) !== 'WIN') {
	$log = &Log::singleton('syslog', LOG_LOCAL5, $logid);
} else {
	$opts = array('locking' => true, 'timeFormat' => '%Y/%m/%d %H:%M:%S');
	$log = &Log::singleton('file', '/opt/secioss/var/log/auth.log', $logid, $opts);
}

$conf = parse_ini_file("../conf/config.ini", true);
if (empty($conf)) {
	 $log->crit(logformat("Can't read config.ini"));
	 exit(1);
}
if (!isset($conf['password'])) {
	 $log->crit(logformat("Set password configuration"));
	 exit(1);
}

$code = 1;
$message = '';
$response_xml = 
'<?xml version="1.0" encoding="UTF-8"?>
<response>
  <code>%d</code>
  <message>%s</message>
</response>
';

if (isset($_SESSION['authuser']) && isset($_SESSION['authpwd'])) {
	$conf['password']['binddn'] = $_SESSION['authuser'];
	$conf['password']['bindpw'] = $_SESSION['authpwd'];
}
else {
	$message = 'Not authenticated';
	printf($response_xml, $code, $message);
	exit(0);
}
if (isset($_GET['username']) && isset($_POST['password'])) {
	$username = mb_convert_encoding($_GET['username'], "SJIS", "UTF-8");	// usernameをUTF-8からSJISへ変更
	$_SERVER['REMOTE_USER'] = $username;
}
else {
	$message = 'Username or password is not set';
	printf($response_xml, $code, $message);
	exit(0);
}


$login = new AutoLogin('LDAP', $conf['password'], null);
$rc = $login->setUser($username, true);
if (PEAR::isError($rc)) {
	$log->err(logformat("Changing password failed: ". $rc->getMessage()));
	//$message = USS_ERR_003;
	$message = "Changing password failed: ".$rc->getMessage();
}
else if (isset($_POST['password']) /*&& checkCsrf($csrf)*/) {
	$password = $_POST['password'];

	$rc = $login->changePasswd($password, false);
	if (PEAR::isError($rc)) {
		switch($rc->getCode()) {
			case AUTO_LOGIN_INVALID_VALUE:
				$log->err(logformat("Password is invalid"));
				$message = USS_ERR_001;
				break;
			case AUTO_LOGIN_MIN_AGE:
				$log->err(logformat("Minimum time doesn't elapse between modification to the password"));
				$message = USS_ERR_005;
				break;
			case AUTO_LOGIN_IN_HISTORY:
				$log->err(logformat("Password is in the history"));
				$message = USS_ERR_006;
				break;
			case AUTO_LOGIN_WEAK_PASSWD:
			case AUTO_LOGIN_WEAK_PASSWD_WARN:
				$errmsg = $rc->getMessage();
				if (preg_match('/too short/', $errmsg)) {
					$message = USS_ERR_011;
				} else if (preg_match('/DIFFERENT characters/', $errmsg)) {
					$message = USS_ERR_401;
				} else if (preg_match('/all whitespace/', $errmsg)) {
					$message = USS_ERR_402;
				} else if (preg_match('/too simplistic\/systematic/', $errmsg)) {
					$message = USS_ERR_403;
				} else if (preg_match('/National Insurance number/', $errmsg)) {
					$message = USS_ERR_403;
				} else if (preg_match('/dictionary word/', $errmsg)) {
					$message = USS_ERR_404;
				}
				if ($rc->getCode() == AUTO_LOGIN_WEAK_PASSWD) {
					$log->err(logformat("Password is weark: $errmsg"));
				} else {
					$log->err(logformat("Changing password succeeded but password is weak: $errmsg"));
					$message = USS_NML_001."<br>($message)";
				}
				break;
			case AUTO_LOGIN_MIN_PASSWD:
				$log->err(logformat("Password length is too short"));
				$message = USS_ERR_011;
				break;
			case AUTO_LOGIN_MAX_PASSWD:
				$log->err(logformat("Password length is too long"));
				$message = USS_ERR_012;
				break;
			default:
				$log->err(logformat("Changing password failed: ". $rc->getMessage()));
				//$message = USS_ERR_002;
				$message = "Changing password failed: ".$rc->getMessage();
		}
	}
	else if ($rc) {
		$code = 0;
		$log->notice(logformat("Changing password succeeded"));
		$message = USS_NML_001;
		if (!isset($_COOKIE['auth_tkt'])) {
			$_SESSION['password'] = $password;
		}
	}
}

printf($response_xml, $code, $message);

?>