#!/usr/bin/perl

use strict;
use File::Basename;

my $basedir = dirname(__FILE__);

sub file_get_contents
{
    my ($file) = @_;
    open(IN, "<$file");
    local $/ = undef;
    my $content = <IN>;
    close IN;

    return $content;
}

my $app = $ARGV[0];
my $ldapnum = $ARGV[1];
my $s;

$| = 1;

if ($app eq 'idm') {
    my @sync_types;
    $sync_types[1] = 'Organization';
    $sync_types[2] = 'Group';
    $sync_types[3] = 'SecurityGroup';
    $sync_types[4] = 'Contact';

    my $tenant;
    for (;;) {
        print "eig: ";
        $s = <STDIN>;
        chomp($s);
        if ($s) {
            $tenant = $s;
            last;
        } else {
            print "lݒ肵ĉB\n";
        }
    }

    my $ldapuri;
    for (;;) {
        print "LDAPT[o URI: ";
        $s = <STDIN>;
        chomp($s);
        if ($s) {
            $ldapuri = $s;
            last;
        } else {
            print "lݒ肵ĉB\n";
        }
    }

    my $basedn;
    for (;;) {
        print "LDAPT[o x[XDN: ";
        $s = <STDIN>;
        chomp($s);
        if ($s) {
            $basedn = $s;
            last;
        } else {
            print "lݒ肵ĉB\n";
        }
    }

    my $binddn;
    for (;;) {
        print "LDAPT[o [UDN: ";
        $s = <STDIN>;
        chomp($s);
        if ($s) {
            $binddn = $s;
            last;
        } else {
            print "lݒ肵ĉB\n";
        }
    }

    my $bindpw;
    for (;;) {
        print "LDAPT[o pX[h: ";
        $s = <STDIN>;
        chomp($s);
        if ($s) {
            $bindpw = $s;
            last;
        } else {
            print "lݒ肵ĉB\n";
        }
    }

    my $adminuser;
    for (;;) {
        print "M惆[UID: ";
        $s = <STDIN>;
        chomp($s);
        if ($s) {
            $adminuser = $s;
            last;
        } else {
            print "lݒ肵ĉB\n";
        }
    }

    my $adminpw;
    for (;;) {
        print "MpX[h: ";
        $s = <STDIN>;
        chomp($s);
        if ($s) {
            $adminpw = $s;
            last;
        } else {
            print "lݒ肵ĉB\n";
        }
    }

    print "Gg[1.gD 2.[UO[v 3.ZLeBO[v 4.A]: ";
    $s = <STDIN>;
    chomp($s);
    my $type = $s;

    print "gD̃x[XDN: ";
    $s = <STDIN>;
    chomp($s);
    my $obasedn = $s;

    print "[UO[ṽx[XDN: ";
    $s = <STDIN>;
    chomp($s);
    my $gbasedn = $s;

    print "Ãx[XDN: ";
    $s = <STDIN>;
    chomp($s);
    my $cbasedn = $s;

    print "gD珜OOU: ";
    $s = <STDIN>;
    chomp($s);
    my $exorgs = $s;

    my $ldapuri2;
    my $basedn2;
    my $binddn2;
    my $bindpw2;
    my $type2;
    my $obasedn2;
    my $gbasedn2;
    my $cbasedn2;
    my $exorgs2;
    if ($ldapnum && $ldapnum eq 'multi') {
        print "2ڂLDAPT[oݒ肵ĉB\n";
        for (;;) {
            print "LDAPT[o URI: ";
            $s = <STDIN>;
            chomp($s);
            if ($s) {
                $ldapuri2 = $s;
                last;
            } else {
                print "lݒ肵ĉB\n";
            }
        }

        for (;;) {
            print "LDAPT[o x[XDN: ";
            $s = <STDIN>;
            chomp($s);
            if ($s) {
                $basedn2 = $s;
                last;
            } else {
                print "lݒ肵ĉB\n";
            }
        }

        for (;;) {
            print "LDAPT[o [UDN: ";
            $s = <STDIN>;
            chomp($s);
            if ($s) {
                $binddn2 = $s;
                last;
            } else {
               print "lݒ肵ĉB\n";
            }
        }

        for (;;) {
            print "LDAPT[o pX[h: ";
            $s = <STDIN>;
            chomp($s);
            if ($s) {
                $bindpw2 = $s;
                last;
            } else {
                print "lݒ肵ĉB\n";
            }
        }

        print "Gg[1.gD 2.[UO[v 3.ZLeBO[v 4.A]: ";
        $s = <STDIN>;
        chomp($s);
        $type2 = $s;

        print "gD̃x[XDN: ";
        $s = <STDIN>;
        chomp($s);
        $obasedn2 = $s;

        print "[UO[ṽx[XDN: ";
        $s = <STDIN>;
        chomp($s);
        $gbasedn2 = $s;

        print "Ãx[XDN: ";
        $s = <STDIN>;
        chomp($s);
        $cbasedn2 = $s;

        print "gD珜OOU: ";
        $s = <STDIN>;
        chomp($s);
        $exorgs2 = $s;
    }

    my $file = 'lism-idp.conf';
    if ($ldapnum && $ldapnum eq 'multi') {
        $file = 'lism-idp.conf.mforest';
    }
    my $content = &file_get_contents("$basedir/$file");
    $content =~ s/LDAPURI/$ldapuri/;
    $content =~ s/LDAPBASEDN/$basedn/;
    $content =~ s/LDAPBINDDN/$binddn/;
    $content =~ s/LDAPBINDPW/$bindpw/;
    $content =~ s/TENANTID/$tenant/g;
    $content =~ s/ADMINID/$adminuser/g;
    $content =~ s/ADMINPW/$adminpw/;
    if ($type) {
        foreach my $n (split(/, */g, $type)) {
            my $sync_type = $sync_types[$n];
            $content =~ s/<!-- $sync_type/<!-- $sync_type  -->/g;
            $content =~ s/ $sync_type -->/<!--  $sync_type -->/g;
        }
    }
    $obasedn .= !$obasedn || $obasedn =~ /,$/ ? '' : ',';
    $content =~ s/OBASEDN/$obasedn/g;
    $gbasedn .= !$gbasedn || $gbasedn =~ /,$/ ? '' : ',';
    $content =~ s/GBASEDN/$gbasedn/g;
    $cbasedn .= !$cbasedn || $cbasedn =~ /,$/ ? '' : ',';
    $content =~ s/CBASEDN/$cbasedn/g;
    if ($exorgs) {
        $exorgs =~ s/, */\|/g;
        $exorgs = '|'.$exorgs;
    } else {
        $exorgs = '';
    }
    $content =~ s/EXORGS/$exorgs/;
    if ($ldapnum && $ldapnum eq 'multi') {
        $content =~ s/LDAP_URI2/$ldapuri2/;
        $content =~ s/LDAP_BASEDN2/$basedn2/;
        $content =~ s/LDAP_BINDDN2/$binddn2/;
        $content =~ s/LDAP_BINDPW2/$bindpw2/;
        if ($type2) {
            foreach my $n (split(/, */g, $type2)) {
                my $sync_type = uc($sync_types[$n]).'2';
                $content =~ s/<!-- $sync_type/<!-- $sync_type  -->/g;
                $content =~ s/ $sync_type -->/<!--  $sync_type -->/g;
            }
        }
        $obasedn2 .= !$obasedn2 || $obasedn2 =~ /,$/ ? '' : ',';
        $content =~ s/O_BASEDN2/$obasedn2/g;
        $gbasedn2 .= !$gbasedn2 || $gbasedn2 =~ /,$/ ? '' : ',';
        $content =~ s/G_BASEDN2/$gbasedn2/g;
        $cbasedn2 .= !$cbasedn2 || $cbasedn2 =~ /,$/ ? '' : ',';
        $content =~ s/C_BASEDN2/$cbasedn2/g;
        if ($exorgs2) {
            $exorgs2 =~ s/, */\|/g;
            $exorgs2 = '|'.$exorgs2;
        } else {
            $exorgs2 = '';
        }
        $content =~ s/EX_ORGS/$exorgs2/;
    }
    open FD, ">/opt/secioss/etc/lism-idp.conf";
    print FD $content;
    close FD;
} elsif ($app eq 'sso') {
    my $host;
    for (;;) {
        print "zXgi: https://idp.example.comj: ";
        $s = <STDIN>;
        chomp($s);
        if ($s) {
            $host = $s;
            last;
        } else {
            print "lݒ肵ĉB\n";
        }
    }

    my $ldapuri;
    for (;;) {
        print "LDAPT[o URI: ";
        $s = <STDIN>;
        chomp($s);
        if ($s) {
            $ldapuri = $s;
            last;
        } else {
            print "lݒ肵ĉB\n";
        }
    }

    my $basedn;
    for (;;) {
        print "LDAPT[o x[XDN: ";
        $s = <STDIN>;
        chomp($s);
        if ($s) {
            $basedn = $s;
            last;
        } else {
            print "lݒ肵ĉB\n";
        }
    }

    my $binddn;
    for (;;) {
        print "LDAPT[o [UDN: ";
        $s = <STDIN>;
        chomp($s);
        if ($s) {
            $binddn = $s;
            last;
        } else {
            print "lݒ肵ĉB\n";
        }
    }

    my $bindpw;
    for (;;) {
        print "LDAPT[o pX[h: ";
        $s = <STDIN>;
        chomp($s);
        if ($s) {
            $bindpw = $s;
            last;
        } else {
            print "lݒ肵ĉB\n";
        }
    }

    my $winauth;
    for (;;) {
        print "Fؕ[1.ID/pX[hF 2.WindowsF]: ";
        $s = <STDIN>;
        chomp($s);
        if ($s) {
            $winauth = $s;
            last;
        } else {
            print "lݒ肵ĉB\n";
        }
    }

    my $content = &file_get_contents("$basedir/saml20-idp-hosted.php");
    $content =~ s/https:\/\/idp\.example\.com/$host/;
    if ($winauth == 1) {
        $content =~ s/login-env\.php/login.php/;
    }
    open FD, ">/opt/secioss/share/simplesamlphp/metadata/saml20-idp-hosted.php";
    print FD $content;
    close FD;

    $content = &file_get_contents("$basedir/ldap.php");
    $content =~ s/'auth\.ldap\.hostname'   => 'localhost'/'auth.ldap.hostname'   => \'$ldapuri\'/;
    $content =~ s/'auth\.ldap\.search\.base' => 'dc=example,dc=com'/'auth.ldap.search.base' => \'$basedn\'/;
    $content =~ s/'auth\.ldap\.search\.username' => 'cn=Manager,dc=example,dc=com'/'auth.ldap.search.username' => \'$binddn\'/;
    $content =~ s/'auth\.ldap\.search\.password' => 'secret'/'auth.ldap.search.password' => \'$bindpw\'/;
    open FD, ">/opt/secioss/share/simplesamlphp/config/ldap.php";
    print FD $content;
    close FD;

    $content = &file_get_contents("$basedir/idsync.ini");
    $content =~ s/uri = "ldap:\/\/localhost"/uri = \"$ldapuri\"/;
    $content =~ s/basedn = "DC=example,DC=com"/basedn = \"$basedn\"/;
    open FD, ">/opt/secioss/var/www/conf/idsync.ini";
    print FD $content;
    close FD;
} else {
    print "usage: config.pl [sso|idm]\n";
}
