<?php

/**
 * @file
 * Sample client add script.
 *
 * Obviously not production-ready code, just simple and to the point.
 */
$logid = 'OAuth2';

include 'lib/PDOOAuth2.inc';
require_once 'Smarty/Smarty.class.php';
require_once '/var/www/lib/util.php';

$conf = parse_ini_file('/var/www/conf/oauth.conf');
if (empty($conf)) {
    $log->err(logformat("Can't read oauth.conf"));
    exit(1);
}

if (!isset($_SERVER['REMOTE_USER'])) {
    $log->err(logformat("User isn't authenticated"));
    exit(1);
}

if ($_POST && isset($_POST['client_id']) && isset($_POST['client_secret']) && isset($_POST['redirect_uri'])) {
    $oauth = new PDOOAuth2($conf);
    $oauth->addClient($_POST['client_id'], $_POST['client_secret'], $_POST['redirect_uri']);
}

$smarty = new Smarty();
$smarty->template_dir = 'templates';
$smarty->compile_dir = 'templates_c';
$smarty->display('addclient.tpl');
