<?php
/**
 * Storage.php
 *
 * PHP 5.4
 *
 * @package Auth
 *
 * @author Kaoru Sekiguchi <sekiguchi.kaoru@secioss.co.jp>
 * @copyright 2020 SECIOSS, INC.
 */
namespace Secioss\Enterprise;

/**
 * Secioss\Enterprise\Storage
 */
interface Storage extends \Secioss\Simple\Storage
{
    /**
     * ログインIDを取得する。
     *
     * @return string ログインID
     */
    public function getLoginId();

    /**
     * 暗号化されているパスワードを復号化して取得する
     *
     * @param null|string $app
     *
     * @return string パスワード
     */
    public function getPassword($app = null);

    /**
     * パスワードを暗号化してストレージに格納する
     *
     * @param string      $password パスワード
     * @param null|string $app      アプリケーション
     * @param null|string $init
     * @param null|string $random
     *
     * @return mixed 0:正常終了 PEAR_Error:エラー
     */
    public function setPassword($password, $app = null, $init = false, $random = null);

    /**
     * アプリのパスワード削除
     *
     * @param string $app アプリケーション
     *
     * @return mixed 0:正常終了 PEAR_Error:エラー
     */
    public function deletePassword($app);

    /**
     * パスワード変更時間を取得する
     *
     * @return string パスワード変更時間（秒）
     */
    public function getPwdChangedTime();

    /**
     * パスワード履歴を取得する
     *
     * @return mixed パスワード履歴
     */
    public function getPwdHistory();

    /**
     * ロックアウトを取得する。
     *
     * @return string ロックアウト
     */
    public function getPwdLockout();

    /**
     * パスワード強制変更フラグを取得する
     *
     * @return string パスワード強制変更フラグ
     */
    public function isPwdMustChange();

    /**
     * プロファイル一覧を取得する
     *
     * @return array プロファイルDN一覧
     */
    public function getProfiles();

    /**
     * プロファイルのカスタムコンフィグを取得する
     *
     * @param null|mixed $tenant
     *
     * @return array プロファイルのカスタムコンフィグ
     */
    public function getProfileConf($tenant = null);

    public function getPwdPolicy($tenant = null);

    public function setDevice($device, $deviceid, $status, $os, $ip, $note, $appver);

    public function deleteDevice($device, $deviceid);

    /**
     * 登録済み端末数
     *
     * @param string $ltype  ライセンスタイプ
     * @param string $dtype  デバイスタイプ
     * @param string $newid  端末ID
     * @param string $tenant テナントID
     *
     * @return int 登録済み端末数
     */
    public function getDeviceCurrentNum($ltype, $dtype, $newid, $tenant);
}
