/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.sed;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import net.morilib.sed.SedCommandBundle;
import net.morilib.sed.SedCommandLine;
import net.morilib.sed.SedEngine;
import net.morilib.sed.SedParser;
import net.morilib.sed.SedPatternEngine;

public class Sed {
    public static int execute(SedCommandBundle b, Reader command, Reader reader, Writer writer, SedPatternEngine engine, boolean display) throws IOException {
        List<SedCommandLine> cmds = SedParser.parse(b, command);
        return SedEngine.execute(reader, writer, engine, display, cmds.toArray(new SedCommandLine[0]));
    }

    public static int execute(SedCommandBundle b, String command, Reader reader, Writer writer, SedPatternEngine engine, boolean display) throws IOException {
        return Sed.execute(b, new StringReader(command), reader, writer, engine, display);
    }

    public static int execute(Reader command, Reader reader, Writer writer, SedPatternEngine engine, boolean display) throws IOException {
        return Sed.execute(SedCommandBundle.getInstance(), command, reader, writer, engine, display);
    }

    public static int execute(String command, Reader reader, Writer writer, SedPatternEngine engine, boolean display) throws IOException {
        return Sed.execute(SedCommandBundle.getInstance(), new StringReader(command), reader, writer, engine, display);
    }

    public static void execute(SedCommandBundle bl, String command, File inputFile, File outputFile, String inputEncoding, String outputEncoding, SedPatternEngine engine, boolean display) throws IOException {
        Reader rd = null;
        Writer wr = null;
        try {
            rd = inputEncoding != null ? new InputStreamReader((InputStream)new FileInputStream(inputFile), inputEncoding) : new InputStreamReader(new FileInputStream(inputFile));
            wr = outputEncoding != null ? new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), outputEncoding) : new OutputStreamWriter(new FileOutputStream(outputFile));
            Sed.execute(bl, command, rd, wr, engine, display);
        }
        finally {
            if (rd != null) {
                rd.close();
            }
            if (wr != null) {
                wr.flush();
                wr.close();
            }
        }
    }

    public static void executeAndOverwrite(SedCommandBundle bl, String command, File file, String inputEncoding, String outputEncoding, SedPatternEngine engine, boolean display) throws IOException {
        File tf = File.createTempFile("sedaf", ".tmp");
        BufferedOutputStream ous = null;
        BufferedInputStream ins = null;
        byte[] b = new byte[4096];
        try {
            int l;
            Sed.execute(bl, command, file, tf, inputEncoding, outputEncoding, engine, display);
            ins = new BufferedInputStream(new FileInputStream(tf));
            ous = new BufferedOutputStream(new FileOutputStream(file));
            while ((l = ins.read(b)) >= 0) {
                ous.write(b, 0, l);
            }
        }
        finally {
            if (ins != null) {
                ins.close();
            }
            if (ous != null) {
                ous.flush();
                ous.close();
            }
            tf.delete();
        }
    }

    public static String execute(SedCommandBundle b, String command, String input, String inputEncoding, String outputEncoding, SedPatternEngine engine, boolean display) throws IOException {
        StringReader rd = new StringReader(input);
        StringWriter wr = new StringWriter();
        Sed.execute(b, command, (Reader)rd, (Writer)wr, engine, display);
        return wr.toString();
    }
}

