/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.sed.cmd;

import java.io.IOException;

import net.morilib.sed.SedCommand;
import net.morilib.sed.SedLineBuffer;
import net.morilib.sed.SedSpace;


public class SedACommand implements SedCommand {

	private String string;

	public SedACommand(String string) {
		if(string == null)  throw new NullPointerException();
		this.string  = string;
	}

	public String getLongDescription() {
		return "Append";
	}

	public char getName() {
		return 'a';
	}

	public void process(SedSpace s,
			SedLineBuffer rd) throws IOException {
		s.appendLines(string);
	}

	public String getString() {
		return string;
	}

	public int hashCode() {
		return string.hashCode();
	}

	public boolean equals(Object o) {
		if(o instanceof SedACommand) {
			return string.equals(((SedACommand)o).string);
		}
		return false;
	}

	public String toString() {
		return "a" + string;
	}

}
