/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.sed.gui;

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.LinkedList;
import java.util.List;

import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

import net.morilib.sed.Sed;
import net.morilib.sed.SedCommandBundle;
import net.morilib.sed.SedSyntaxException;
import net.morilib.sed.pattern.SedBasicRegexEngine;
import net.morilib.unix.glob.WildcardFileFilter;

public class SedFrame extends JFrame {

	//
	class SedImmediate extends JDialog {

		//
		JTextArea left = new JTextArea(), right = new JTextArea();

		SedImmediate() {
			super(SedFrame.this, "sedafter - immediate");

			//
			Container cp = getContentPane();
			JSplitPane s1 = new JSplitPane(JSplitPane.HORIZONTAL_SPLIT);
			JButton b1;

			setDefaultCloseOperation(HIDE_ON_CLOSE);
			setSize(500, 400);

			s1.setLeftComponent(left);
			s1.setRightComponent(right);
			s1.setResizeWeight(0.5);

			b1 = new JButton("execute");
			b1.addActionListener(new ActionListener() {

				public void actionPerformed(ActionEvent ev) {
					try {
						String s = Sed.execute(
								SedCommandBundle.getInstance(),
								t2.getText(),
								left.getText(),
								null,
								null,
								SedBasicRegexEngine.getInstance(),
								!c2.isSelected());

						right.setText(s);
					} catch(IOException e) {
						errbox("I/O error");
					} catch(SedSyntaxException e) {
						errbox("script syntax error");
					}
				}

			});

			cp.setLayout(new BorderLayout());
			cp.add(s1, BorderLayout.CENTER);
			cp.add(b1, BorderLayout.SOUTH);
		}

	}

	private JTextField t1 = new JTextField(50);
	private JTextArea t2 = new JTextArea();
	private JComboBox c3 = new JComboBox();
	private JFileChooser f1 = new JFileChooser();
	private JCheckBox c1 = new JCheckBox("apply for subfolders");
	private JCheckBox c2 = new JCheckBox(
			"not display the pattern space");

	private JMenuBar mb = new JMenuBar();
	private JFileChooser f2 = new JFileChooser("open a script");
	private JFileChooser f3 = new JFileChooser("save the script");

	private File script;
	private SedImmediate immediate = new SedImmediate();

	boolean addfs(List<File> fs, File f, boolean dir) {
		if(f.isDirectory()) {
			for(File g : f.listFiles()) {
				if(g.isFile() || (g.isDirectory() && dir))  fs.add(g);
			}
			return false;
		} else {
			return true;
		}
	}

	void warnbox(String s) {
		JOptionPane.showMessageDialog(
				this, s, "sedafter", JOptionPane.WARNING_MESSAGE);
	}

	void errbox(String s) {
		JOptionPane.showMessageDialog(
				this, s, "sedafter", JOptionPane.ERROR_MESSAGE);
	}

	void infobox(String... ss) {
		StringBuffer b = new StringBuffer();

		for(String s : ss)  b.append(s).append('\n');
		JOptionPane.showMessageDialog(
				this, b.toString(), "sedafter",
				JOptionPane.INFORMATION_MESSAGE);
	}

	void exec1() {
		List<File> fs = new LinkedList<File>();
		WildcardFileFilter ff;
		String s = t1.getText();
		Object sf = c3.getSelectedItem();
		File f;

		if(s == null || s.equals("")) {
			warnbox("path required");
			return;
		} else if(sf == null || sf.equals("")) {
			warnbox("file filter required");
			return;
		}

		ff = new WildcardFileFilter(sf.toString());
		try {
			fs.add(new File(t1.getText()));
			while(!fs.isEmpty()) {
				f = fs.remove(0);
				if(addfs(fs, f, c1.isSelected()) && ff.accept(f)) {
					Sed.executeAndOverwrite(
							SedCommandBundle.getInstance(),
							t2.getText(),
							f,
							null,
							null,
							SedBasicRegexEngine.getInstance(),
							!c2.isSelected());
				}
			}
			infobox("execute completed");
		} catch(IOException e) {
			errbox("I/O error");
		} catch(SedSyntaxException e) {
			errbox("script syntax error");
		}
	}

	private void closeq(Closeable c) {
		if(c != null) {
			try {
				c.close();
			} catch(IOException e) {
				throw new RuntimeException(e);
			}
		}
	}

	private void load1(File f) {
		StringWriter wr = new StringWriter();
		Reader rd = null;
		char[] a = new char[2048];
		int l;

		try {
			rd = new InputStreamReader(new FileInputStream(f));
			while((l = rd.read(a)) >= 0)  wr.write(a, 0, l);
			wr.flush();
			t2.setText(wr.toString());
		} catch(IOException e) {
			errbox("I/O error");
		} finally {
			closeq(rd);
		}
		
	}

	private void save1(File f) {
		Writer wr = null;

		try {
			wr = new OutputStreamWriter(new FileOutputStream(f));
			wr.write(t2.getText());
			wr.flush();
		} catch(IOException e) {
			errbox("I/O error");
		} finally {
			closeq(wr);
		}
	}

	SedFrame() {
		super("sedafter");

		//
		Container cp;
		GridBagConstraints ct = new GridBagConstraints();
		JPanel p1 = new JPanel();
		JMenu m1;
		JMenuItem i1;
		JButton b1, b2;

		setDefaultCloseOperation(EXIT_ON_CLOSE);
		setSize(500, 400);
		cp = getContentPane();
		cp.setLayout(new BorderLayout());
		p1.setLayout(new GridBagLayout());
		f1.setFileSelectionMode(JFileChooser.FILES_AND_DIRECTORIES);

		ct.gridwidth = ct.gridheight = 1;
		ct.weightx = ct.weighty = 1;
		ct.fill = GridBagConstraints.BOTH;
		p1.add(new JLabel("Path:"), ct);

		ct.weightx = 8;
		p1.add(t1, ct);

		ct.weightx = 1;
		ct.gridwidth = GridBagConstraints.REMAINDER;
		b1 = new JButton("File");
		b1.addActionListener(new ActionListener() {

			public void actionPerformed(ActionEvent e) {
				File f;

				f1.showDialog(SedFrame.this, "open");
				f = f1.getSelectedFile();
				if(f != null)  t1.setText(f.toString());
			}

		});
		p1.add(b1, ct);

		ct.gridwidth = 1;
		p1.add(new JLabel("Filter:"), ct);

		ct.gridwidth = GridBagConstraints.REMAINDER;
		c3.addItem("*");
		c3.setEditable(true);
		p1.add(c3, ct);

		ct.gridwidth = 2;
		p1.add(c1, ct);

		b1 = new JButton("immediate");
		ct.gridwidth = GridBagConstraints.REMAINDER;
		b1.addActionListener(new ActionListener() {

			public void actionPerformed(ActionEvent e) {
				immediate.setVisible(true);
			}

		});
		p1.add(b1, ct);

		ct.gridwidth = GridBagConstraints.REMAINDER;
		p1.add(c2, ct);

		cp.add(p1, BorderLayout.NORTH);
		cp.add(new JScrollPane(t2), BorderLayout.CENTER);

		b2 = new JButton("execute");
		b2.addActionListener(new ActionListener() {

			public void actionPerformed(ActionEvent e) {
				exec1();
			}

		});
		cp.add(b2, BorderLayout.SOUTH);

		m1 = new JMenu("File");
		i1 = new JMenuItem("Open File...");
		i1.addActionListener(new ActionListener() {

			public void actionPerformed(ActionEvent e) {
				File f;

				f2.showOpenDialog(SedFrame.this);
				if((f = f2.getSelectedFile()) != null) {
					load1(script = f);
				}
			}

		});
		i1.setMnemonic('o');
		i1.setAccelerator(KeyStroke.getKeyStroke(
				KeyEvent.VK_O, InputEvent.CTRL_MASK));
		m1.add(i1);

		i1 = new JMenuItem("Save");
		i1.addActionListener(new ActionListener() {

			public void actionPerformed(ActionEvent e) {
				save1(script);
			}

		});
		i1.setMnemonic('s');
		i1.setAccelerator(KeyStroke.getKeyStroke(
				KeyEvent.VK_S, InputEvent.CTRL_MASK));
		m1.add(i1);

		i1 = new JMenuItem("Save As...");
		i1.addActionListener(new ActionListener() {

			public void actionPerformed(ActionEvent e) {
				File f;

				f3.showOpenDialog(SedFrame.this);
				if((f = f3.getSelectedFile()) != null) {
					save1(script = f);
				}
			}

		});
		i1.setMnemonic('a');
		m1.add(i1);
		mb.add(m1);

		m1 = new JMenu("Help");
		i1 = new JMenuItem("Show Immediate Window");
		i1.addActionListener(new ActionListener() {

			public void actionPerformed(ActionEvent e) {
				immediate.setVisible(true);
			}

		});
		i1.setMnemonic('a');
		m1.add(i1);

		i1 = new JMenuItem("About Sedafter");
		i1.addActionListener(new ActionListener() {

			public void actionPerformed(ActionEvent e) {
				infobox("Sedafter Version 0.0.0",
						"Copyright 2013 Yuichiro Moriguchi",
						"This software under Apache 2.0 License");
			}

		});
		m1.add(i1);
		mb.add(m1);
		setJMenuBar(mb);
	}

	public static void main(String[] args) {
		new SedFrame().setVisible(true);
	}

}
