/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.sed.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.io.PushbackReader;
import java.io.StringReader;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.morilib.sed.Sed;
import net.morilib.sed.SedCommandBundle;
import net.morilib.sed.SedCommandParser;
import net.morilib.sed.SedParser;
import net.morilib.sed.SedPatternEngine;
import net.morilib.sed.SedSyntaxException;
import net.morilib.sed.gui.CharsetComboBox;
import net.morilib.sed.gui.SedOutputDialog;
import net.morilib.sed.gui.SedQuestionCommand;
import net.morilib.sed.parser.SedSimpleCommandParser;
import net.morilib.sed.pattern.JavaStandardSedPatternEngine;
import net.morilib.sed.pattern.SedBasicRegexEngine;
import net.morilib.unix.glob.WildcardFileFilter;
import net.morilib.unix.regex.BasicPatternSyntaxException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class GrepFrame
extends JFrame {
    private JTextField t1 = new JTextField(50);
    private JTextField t2 = new JTextField(50);
    private JComboBox c3 = new JComboBox();
    private JFileChooser f1 = new JFileChooser();
    private JCheckBox c1 = new JCheckBox("apply for subfolders");
    private JComboBox c4 = new JComboBox();
    private CharsetComboBox cs1 = new CharsetComboBox();
    private JMenuBar mb = new JMenuBar();
    private SedOutputDialog dialog;
    private SedCommandBundle bundle;
    private SedQuestionCommand qcmd;

    boolean addfs(List<File> fs, File f, boolean dir) {
        if (f.isDirectory()) {
            File[] fileArray = f.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File g = fileArray[n2];
                if (g.isFile() || g.isDirectory() && dir) {
                    fs.add(g);
                }
                ++n2;
            }
            return false;
        }
        return true;
    }

    void warnbox(String s) {
        JOptionPane.showMessageDialog(this, s, "grepafter", 2);
    }

    void errbox(String s) {
        JOptionPane.showMessageDialog(this, s, "grepafter", 0);
    }

    void infobox(String ... ss) {
        StringBuffer b = new StringBuffer();
        String[] stringArray = ss;
        int n = ss.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            b.append(s).append('\n');
            ++n2;
        }
        JOptionPane.showMessageDialog(this, b.toString(), "grepafter", 1);
    }

    void exec1() {
        LinkedList<File> fs = new LinkedList<File>();
        String s = this.t1.getText();
        Object sf = this.c3.getSelectedItem();
        if (s == null || s.equals("")) {
            this.warnbox("path required");
            return;
        }
        if (sf == null || sf.equals("")) {
            this.warnbox("file filter required");
            return;
        }
        try {
            PushbackReader r = new PushbackReader(new StringReader(this.t2.getText()));
            SedParser.parseLines(r);
            if (r.read() >= 0) {
                this.errbox("invaild line");
                return;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.dialog.inittable();
        WildcardFileFilter ff = new WildcardFileFilter(sf.toString());
        try {
            fs.add(new File(this.t1.getText()));
            while (!fs.isEmpty()) {
                File f = (File)fs.remove(0);
                if (!this.addfs(fs, f, this.c1.isSelected()) || !ff.accept(f)) continue;
                this.qcmd.path = f.toString();
                Sed.executeOnlyInput(this.bundle, String.valueOf(this.t2.getText()) + "?", f, this.cs1.getSelectedCharset(), (SedPatternEngine)this.c4.getSelectedItem(), false);
            }
            this.dialog.showDialog();
            this.infobox("execute completed");
        }
        catch (IOException e) {
            this.errbox("I/O error");
        }
        catch (SedSyntaxException e) {
            this.errbox("invalid line");
        }
        catch (BasicPatternSyntaxException e) {
            this.errbox("invalid regular expression");
        }
    }

    GrepFrame() {
        super("grepafter");
        GridBagConstraints ct = new GridBagConstraints();
        JPanel p1 = new JPanel();
        this.setDefaultCloseOperation(3);
        this.setMinimumSize(new Dimension(200, 300));
        this.setSize(600, 30);
        Container cp = this.getContentPane();
        cp.setLayout(new BorderLayout());
        p1.setLayout(new GridBagLayout());
        this.f1.setFileSelectionMode(2);
        ct.gridheight = 1;
        ct.gridwidth = 1;
        ct.weighty = 1.0;
        ct.weightx = 1.0;
        ct.fill = 1;
        p1.add((Component)new JLabel("Path:"), ct);
        ct.weightx = 8.0;
        p1.add((Component)this.t1, ct);
        ct.weightx = 1.0;
        ct.gridwidth = 0;
        JButton b1 = new JButton("File");
        b1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GrepFrame.this.f1.showDialog(GrepFrame.this, "open");
                File f = GrepFrame.this.f1.getSelectedFile();
                if (f != null) {
                    GrepFrame.this.t1.setText(f.toString());
                }
            }
        });
        p1.add((Component)b1, ct);
        ct.gridwidth = 1;
        p1.add((Component)new JLabel("Filter:"), ct);
        ct.gridwidth = 0;
        this.c3.addItem("*");
        this.c3.setEditable(true);
        p1.add((Component)this.c3, ct);
        ct.gridwidth = 0;
        p1.add((Component)this.c1, ct);
        ct.gridwidth = 1;
        p1.add((Component)new JLabel("Line:"), ct);
        ct.gridwidth = 0;
        p1.add((Component)this.t2, ct);
        ct.gridwidth = 0;
        this.c4.addItem(SedBasicRegexEngine.getInstance());
        this.c4.addItem(JavaStandardSedPatternEngine.getInstance());
        p1.add((Component)this.c4, ct);
        ct.gridwidth = 0;
        p1.add((Component)this.cs1, ct);
        cp.add((Component)p1, "North");
        JButton b2 = new JButton("execute");
        b2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GrepFrame.this.exec1();
            }
        });
        cp.add((Component)b2, "South");
        JMenu m1 = new JMenu("Help");
        JMenuItem i1 = new JMenuItem("About Sedafter");
        i1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GrepFrame.this.infobox("Sedafter Version 0.0.0", "Copyright 2013 Yuichiro Moriguchi", "This software under Apache 2.0 License");
            }
        });
        m1.add(i1);
        this.mb.add(m1);
        this.setJMenuBar(this.mb);
        this.dialog = new SedOutputDialog(this);
        this.bundle = SedCommandBundle.newInstance();
        this.qcmd = new SedQuestionCommand();
        this.qcmd.dialog = this.dialog;
        this.bundle.put(63, (SedCommandParser)new SedSimpleCommandParser(this.qcmd));
    }
}

